/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.ThreatIntelSetIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThreatIntelSetsResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, ListThreatIntelSetsResponse> {
    private static final SdkField<List<String>> THREAT_INTEL_SET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThreatIntelSetIds").getter(ListThreatIntelSetsResponse.getter(ListThreatIntelSetsResponse::threatIntelSetIds)).setter(ListThreatIntelSetsResponse.setter(Builder::threatIntelSetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatIntelSetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListThreatIntelSetsResponse.getter(ListThreatIntelSetsResponse::nextToken)).setter(ListThreatIntelSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THREAT_INTEL_SET_IDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> threatIntelSetIds;
    private final String nextToken;

    private ListThreatIntelSetsResponse(BuilderImpl builder) {
        super(builder);
        this.threatIntelSetIds = builder.threatIntelSetIds;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasThreatIntelSetIds() {
        return this.threatIntelSetIds != null && !(this.threatIntelSetIds instanceof SdkAutoConstructList);
    }

    public final List<String> threatIntelSetIds() {
        return this.threatIntelSetIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreatIntelSetIds() ? this.threatIntelSetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThreatIntelSetsResponse)) {
            return false;
        }
        ListThreatIntelSetsResponse other = (ListThreatIntelSetsResponse)((Object)obj);
        return this.hasThreatIntelSetIds() == other.hasThreatIntelSetIds() && Objects.equals(this.threatIntelSetIds(), other.threatIntelSetIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListThreatIntelSetsResponse").add("ThreatIntelSetIds", this.hasThreatIntelSetIds() ? this.threatIntelSetIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThreatIntelSetIds": {
                return Optional.ofNullable(clazz.cast(this.threatIntelSetIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListThreatIntelSetsResponse, T> g) {
        return obj -> g.apply((ListThreatIntelSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private List<String> threatIntelSetIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThreatIntelSetsResponse model) {
            super(model);
            this.threatIntelSetIds(model.threatIntelSetIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getThreatIntelSetIds() {
            if (this.threatIntelSetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.threatIntelSetIds;
        }

        public final void setThreatIntelSetIds(Collection<String> threatIntelSetIds) {
            this.threatIntelSetIds = ThreatIntelSetIdsCopier.copy(threatIntelSetIds);
        }

        @Override
        public final Builder threatIntelSetIds(Collection<String> threatIntelSetIds) {
            this.threatIntelSetIds = ThreatIntelSetIdsCopier.copy(threatIntelSetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatIntelSetIds(String ... threatIntelSetIds) {
            this.threatIntelSetIds(Arrays.asList(threatIntelSetIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListThreatIntelSetsResponse build() {
            return new ListThreatIntelSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListThreatIntelSetsResponse> {
        public Builder threatIntelSetIds(Collection<String> var1);

        public Builder threatIntelSetIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

