/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DetectorFeature {
    S3_DATA_EVENTS("S3_DATA_EVENTS"),
    EKS_AUDIT_LOGS("EKS_AUDIT_LOGS"),
    EBS_MALWARE_PROTECTION("EBS_MALWARE_PROTECTION"),
    RDS_LOGIN_EVENTS("RDS_LOGIN_EVENTS"),
    EKS_RUNTIME_MONITORING("EKS_RUNTIME_MONITORING"),
    LAMBDA_NETWORK_LOGS("LAMBDA_NETWORK_LOGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DetectorFeature> VALUE_MAP;
    private final String value;

    private DetectorFeature(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DetectorFeature fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DetectorFeature> knownValues() {
        EnumSet<DetectorFeature> knownValues = EnumSet.allOf(DetectorFeature.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DetectorFeature.class, DetectorFeature::toString);
    }
}

