/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.BandwidthUnits;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FrequencyBandwidth
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FrequencyBandwidth> {
    private static final SdkField<String> UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("units").getter(FrequencyBandwidth.getter(FrequencyBandwidth::unitsAsString)).setter(FrequencyBandwidth.setter(Builder::units)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("units").build()}).build();
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("value").getter(FrequencyBandwidth.getter(FrequencyBandwidth::value)).setter(FrequencyBandwidth.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNITS_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String units;
    private final Double value;

    private FrequencyBandwidth(BuilderImpl builder) {
        this.units = builder.units;
        this.value = builder.value;
    }

    public final BandwidthUnits units() {
        return BandwidthUnits.fromValue(this.units);
    }

    public final String unitsAsString() {
        return this.units;
    }

    public final Double value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrequencyBandwidth)) {
            return false;
        }
        FrequencyBandwidth other = (FrequencyBandwidth)obj;
        return Objects.equals(this.unitsAsString(), other.unitsAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"FrequencyBandwidth").add("Units", (Object)this.unitsAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "units": {
                return Optional.ofNullable(clazz.cast(this.unitsAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FrequencyBandwidth, T> g) {
        return obj -> g.apply((FrequencyBandwidth)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String units;
        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(FrequencyBandwidth model) {
            this.units(model.units);
            this.value(model.value);
        }

        public final String getUnits() {
            return this.units;
        }

        public final void setUnits(String units) {
            this.units = units;
        }

        @Override
        @Transient
        public final Builder units(String units) {
            this.units = units;
            return this;
        }

        @Override
        @Transient
        public final Builder units(BandwidthUnits units) {
            this.units(units == null ? null : units.toString());
            return this;
        }

        public final Double getValue() {
            return this.value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public FrequencyBandwidth build() {
            return new FrequencyBandwidth(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FrequencyBandwidth> {
        public Builder units(String var1);

        public Builder units(BandwidthUnits var1);

        public Builder value(Double var1);
    }
}

