/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.grafana.model.GrafanaRequest;
import software.amazon.awssdk.services.grafana.model.UpdateInstruction;
import software.amazon.awssdk.services.grafana.model.UpdateInstructionBatchCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePermissionsRequest
extends GrafanaRequest
implements ToCopyableBuilder<Builder, UpdatePermissionsRequest> {
    private static final SdkField<List<UpdateInstruction>> UPDATE_INSTRUCTION_BATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("updateInstructionBatch").getter(UpdatePermissionsRequest.getter(UpdatePermissionsRequest::updateInstructionBatch)).setter(UpdatePermissionsRequest.setter(Builder::updateInstructionBatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateInstructionBatch").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateInstruction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(UpdatePermissionsRequest.getter(UpdatePermissionsRequest::workspaceId)).setter(UpdatePermissionsRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_INSTRUCTION_BATCH_FIELD, WORKSPACE_ID_FIELD));
    private final List<UpdateInstruction> updateInstructionBatch;
    private final String workspaceId;

    private UpdatePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.updateInstructionBatch = builder.updateInstructionBatch;
        this.workspaceId = builder.workspaceId;
    }

    public final boolean hasUpdateInstructionBatch() {
        return this.updateInstructionBatch != null && !(this.updateInstructionBatch instanceof SdkAutoConstructList);
    }

    public final List<UpdateInstruction> updateInstructionBatch() {
        return this.updateInstructionBatch;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdateInstructionBatch() ? this.updateInstructionBatch() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePermissionsRequest)) {
            return false;
        }
        UpdatePermissionsRequest other = (UpdatePermissionsRequest)((Object)obj);
        return this.hasUpdateInstructionBatch() == other.hasUpdateInstructionBatch() && Objects.equals(this.updateInstructionBatch(), other.updateInstructionBatch()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePermissionsRequest").add("UpdateInstructionBatch", this.hasUpdateInstructionBatch() ? this.updateInstructionBatch() : null).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "updateInstructionBatch": {
                return Optional.ofNullable(clazz.cast(this.updateInstructionBatch()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePermissionsRequest, T> g) {
        return obj -> g.apply((UpdatePermissionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaRequest.BuilderImpl
    implements Builder {
        private List<UpdateInstruction> updateInstructionBatch = DefaultSdkAutoConstructList.getInstance();
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePermissionsRequest model) {
            super(model);
            this.updateInstructionBatch(model.updateInstructionBatch);
            this.workspaceId(model.workspaceId);
        }

        public final List<UpdateInstruction.Builder> getUpdateInstructionBatch() {
            List<UpdateInstruction.Builder> result = UpdateInstructionBatchCopier.copyToBuilder(this.updateInstructionBatch);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdateInstructionBatch(Collection<UpdateInstruction.BuilderImpl> updateInstructionBatch) {
            this.updateInstructionBatch = UpdateInstructionBatchCopier.copyFromBuilder(updateInstructionBatch);
        }

        @Override
        public final Builder updateInstructionBatch(Collection<UpdateInstruction> updateInstructionBatch) {
            this.updateInstructionBatch = UpdateInstructionBatchCopier.copy(updateInstructionBatch);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateInstructionBatch(UpdateInstruction ... updateInstructionBatch) {
            this.updateInstructionBatch(Arrays.asList(updateInstructionBatch));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateInstructionBatch(Consumer<UpdateInstruction.Builder> ... updateInstructionBatch) {
            this.updateInstructionBatch(Stream.of(updateInstructionBatch).map(c -> (UpdateInstruction)((UpdateInstruction.Builder)UpdateInstruction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePermissionsRequest build() {
            return new UpdatePermissionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GrafanaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePermissionsRequest> {
        public Builder updateInstructionBatch(Collection<UpdateInstruction> var1);

        public Builder updateInstructionBatch(UpdateInstruction ... var1);

        public Builder updateInstructionBatch(Consumer<UpdateInstruction.Builder> ... var1);

        public Builder workspaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

