/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVersionsResponse extends GrafanaResponse implements
        ToCopyableBuilder<ListVersionsResponse.Builder, ListVersionsResponse> {
    private static final SdkField<List<String>> GRAFANA_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("grafanaVersions")
            .getter(getter(ListVersionsResponse::grafanaVersions))
            .setter(setter(Builder::grafanaVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grafanaVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAFANA_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> grafanaVersions;

    private final String nextToken;

    private ListVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.grafanaVersions = builder.grafanaVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the GrafanaVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGrafanaVersions() {
        return grafanaVersions != null && !(grafanaVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Grafana versions available to create. If a workspace ID is included in the request, the Grafana versions to
     * which this workspace can be upgraded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGrafanaVersions} method.
     * </p>
     * 
     * @return The Grafana versions available to create. If a workspace ID is included in the request, the Grafana
     *         versions to which this workspace can be upgraded.
     */
    public final List<String> grafanaVersions() {
        return grafanaVersions;
    }

    /**
     * <p>
     * The token to use in a subsequent <code>ListVersions</code> operation to return the next set of results.
     * </p>
     * 
     * @return The token to use in a subsequent <code>ListVersions</code> operation to return the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGrafanaVersions() ? grafanaVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVersionsResponse)) {
            return false;
        }
        ListVersionsResponse other = (ListVersionsResponse) obj;
        return hasGrafanaVersions() == other.hasGrafanaVersions() && Objects.equals(grafanaVersions(), other.grafanaVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVersionsResponse").add("GrafanaVersions", hasGrafanaVersions() ? grafanaVersions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "grafanaVersions":
            return Optional.ofNullable(clazz.cast(grafanaVersions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVersionsResponse, T> g) {
        return obj -> g.apply((ListVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GrafanaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVersionsResponse> {
        /**
         * <p>
         * The Grafana versions available to create. If a workspace ID is included in the request, the Grafana versions
         * to which this workspace can be upgraded.
         * </p>
         * 
         * @param grafanaVersions
         *        The Grafana versions available to create. If a workspace ID is included in the request, the Grafana
         *        versions to which this workspace can be upgraded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grafanaVersions(Collection<String> grafanaVersions);

        /**
         * <p>
         * The Grafana versions available to create. If a workspace ID is included in the request, the Grafana versions
         * to which this workspace can be upgraded.
         * </p>
         * 
         * @param grafanaVersions
         *        The Grafana versions available to create. If a workspace ID is included in the request, the Grafana
         *        versions to which this workspace can be upgraded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grafanaVersions(String... grafanaVersions);

        /**
         * <p>
         * The token to use in a subsequent <code>ListVersions</code> operation to return the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use in a subsequent <code>ListVersions</code> operation to return the next set of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GrafanaResponse.BuilderImpl implements Builder {
        private List<String> grafanaVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVersionsResponse model) {
            super(model);
            grafanaVersions(model.grafanaVersions);
            nextToken(model.nextToken);
        }

        public final Collection<String> getGrafanaVersions() {
            if (grafanaVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return grafanaVersions;
        }

        public final void setGrafanaVersions(Collection<String> grafanaVersions) {
            this.grafanaVersions = GrafanaVersionListCopier.copy(grafanaVersions);
        }

        @Override
        public final Builder grafanaVersions(Collection<String> grafanaVersions) {
            this.grafanaVersions = GrafanaVersionListCopier.copy(grafanaVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grafanaVersions(String... grafanaVersions) {
            grafanaVersions(Arrays.asList(grafanaVersions));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVersionsResponse build() {
            return new ListVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
