/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataSourceType {
    AMAZON_OPENSEARCH_SERVICE("AMAZON_OPENSEARCH_SERVICE"),
    CLOUDWATCH("CLOUDWATCH"),
    PROMETHEUS("PROMETHEUS"),
    XRAY("XRAY"),
    TIMESTREAM("TIMESTREAM"),
    SITEWISE("SITEWISE"),
    ATHENA("ATHENA"),
    REDSHIFT("REDSHIFT"),
    TWINMAKER("TWINMAKER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataSourceType> VALUE_MAP;
    private final String value;

    private DataSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSourceType> knownValues() {
        EnumSet<DataSourceType> knownValues = EnumSet.allOf(DataSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataSourceType.class, DataSourceType::toString);
    }
}

