/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.grafana.DefaultGrafanaBaseClientBuilder;
import software.amazon.awssdk.services.grafana.DefaultGrafanaClient;
import software.amazon.awssdk.services.grafana.GrafanaClient;
import software.amazon.awssdk.services.grafana.GrafanaClientBuilder;
import software.amazon.awssdk.services.grafana.GrafanaServiceClientConfiguration;
import software.amazon.awssdk.services.grafana.endpoints.GrafanaEndpointProvider;

@SdkInternalApi
final class DefaultGrafanaClientBuilder
extends DefaultGrafanaBaseClientBuilder<GrafanaClientBuilder, GrafanaClient>
implements GrafanaClientBuilder {
    DefaultGrafanaClientBuilder() {
    }

    @Override
    public DefaultGrafanaClientBuilder endpointProvider(GrafanaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GrafanaClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultGrafanaClientBuilder.validateClientOptions(clientConfiguration);
        GrafanaServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultGrafanaClient client = new DefaultGrafanaClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private GrafanaServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return GrafanaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

