/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.AuthenticationType;
import software.amazon.awssdk.services.glue.model.BasicAuthenticationCredentials;
import software.amazon.awssdk.services.glue.model.CredentialMapCopier;
import software.amazon.awssdk.services.glue.model.OAuth2PropertiesInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationConfigurationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationConfigurationInput> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationType").getter(AuthenticationConfigurationInput.getter(AuthenticationConfigurationInput::authenticationTypeAsString)).setter(AuthenticationConfigurationInput.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final SdkField<OAuth2PropertiesInput> O_AUTH2_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OAuth2Properties").getter(AuthenticationConfigurationInput.getter(AuthenticationConfigurationInput::oAuth2Properties)).setter(AuthenticationConfigurationInput.setter(Builder::oAuth2Properties)).constructor(OAuth2PropertiesInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuth2Properties").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(AuthenticationConfigurationInput.getter(AuthenticationConfigurationInput::secretArn)).setter(AuthenticationConfigurationInput.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(AuthenticationConfigurationInput.getter(AuthenticationConfigurationInput::kmsKeyArn)).setter(AuthenticationConfigurationInput.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<BasicAuthenticationCredentials> BASIC_AUTHENTICATION_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BasicAuthenticationCredentials").getter(AuthenticationConfigurationInput.getter(AuthenticationConfigurationInput::basicAuthenticationCredentials)).setter(AuthenticationConfigurationInput.setter(Builder::basicAuthenticationCredentials)).constructor(BasicAuthenticationCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuthenticationCredentials").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_AUTHENTICATION_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CustomAuthenticationCredentials").getter(AuthenticationConfigurationInput.getter(AuthenticationConfigurationInput::customAuthenticationCredentials)).setter(AuthenticationConfigurationInput.setter(Builder::customAuthenticationCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAuthenticationCredentials").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD, O_AUTH2_PROPERTIES_FIELD, SECRET_ARN_FIELD, KMS_KEY_ARN_FIELD, BASIC_AUTHENTICATION_CREDENTIALS_FIELD, CUSTOM_AUTHENTICATION_CREDENTIALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthenticationConfigurationInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String authenticationType;
    private final OAuth2PropertiesInput oAuth2Properties;
    private final String secretArn;
    private final String kmsKeyArn;
    private final BasicAuthenticationCredentials basicAuthenticationCredentials;
    private final Map<String, String> customAuthenticationCredentials;

    private AuthenticationConfigurationInput(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.oAuth2Properties = builder.oAuth2Properties;
        this.secretArn = builder.secretArn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.basicAuthenticationCredentials = builder.basicAuthenticationCredentials;
        this.customAuthenticationCredentials = builder.customAuthenticationCredentials;
    }

    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final OAuth2PropertiesInput oAuth2Properties() {
        return this.oAuth2Properties;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final BasicAuthenticationCredentials basicAuthenticationCredentials() {
        return this.basicAuthenticationCredentials;
    }

    public final boolean hasCustomAuthenticationCredentials() {
        return this.customAuthenticationCredentials != null && !(this.customAuthenticationCredentials instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customAuthenticationCredentials() {
        return this.customAuthenticationCredentials;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2Properties());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.basicAuthenticationCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomAuthenticationCredentials() ? this.customAuthenticationCredentials() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationConfigurationInput)) {
            return false;
        }
        AuthenticationConfigurationInput other = (AuthenticationConfigurationInput)obj;
        return Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.oAuth2Properties(), other.oAuth2Properties()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.basicAuthenticationCredentials(), other.basicAuthenticationCredentials()) && this.hasCustomAuthenticationCredentials() == other.hasCustomAuthenticationCredentials() && Objects.equals(this.customAuthenticationCredentials(), other.customAuthenticationCredentials());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticationConfigurationInput").add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("OAuth2Properties", (Object)this.oAuth2Properties()).add("SecretArn", (Object)this.secretArn()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("BasicAuthenticationCredentials", (Object)this.basicAuthenticationCredentials()).add("CustomAuthenticationCredentials", (Object)(this.customAuthenticationCredentials() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "OAuth2Properties": {
                return Optional.ofNullable(clazz.cast(this.oAuth2Properties()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "BasicAuthenticationCredentials": {
                return Optional.ofNullable(clazz.cast(this.basicAuthenticationCredentials()));
            }
            case "CustomAuthenticationCredentials": {
                return Optional.ofNullable(clazz.cast(this.customAuthenticationCredentials()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("OAuth2Properties", O_AUTH2_PROPERTIES_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("BasicAuthenticationCredentials", BASIC_AUTHENTICATION_CREDENTIALS_FIELD);
        map.put("CustomAuthenticationCredentials", CUSTOM_AUTHENTICATION_CREDENTIALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationConfigurationInput, T> g) {
        return obj -> g.apply((AuthenticationConfigurationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationType;
        private OAuth2PropertiesInput oAuth2Properties;
        private String secretArn;
        private String kmsKeyArn;
        private BasicAuthenticationCredentials basicAuthenticationCredentials;
        private Map<String, String> customAuthenticationCredentials = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationConfigurationInput model) {
            this.authenticationType(model.authenticationType);
            this.oAuth2Properties(model.oAuth2Properties);
            this.secretArn(model.secretArn);
            this.kmsKeyArn(model.kmsKeyArn);
            this.basicAuthenticationCredentials(model.basicAuthenticationCredentials);
            this.customAuthenticationCredentials(model.customAuthenticationCredentials);
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final OAuth2PropertiesInput.Builder getOAuth2Properties() {
            return this.oAuth2Properties != null ? this.oAuth2Properties.toBuilder() : null;
        }

        public final void setOAuth2Properties(OAuth2PropertiesInput.BuilderImpl oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties != null ? oAuth2Properties.build() : null;
        }

        @Override
        public final Builder oAuth2Properties(OAuth2PropertiesInput oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final BasicAuthenticationCredentials.Builder getBasicAuthenticationCredentials() {
            return this.basicAuthenticationCredentials != null ? this.basicAuthenticationCredentials.toBuilder() : null;
        }

        public final void setBasicAuthenticationCredentials(BasicAuthenticationCredentials.BuilderImpl basicAuthenticationCredentials) {
            this.basicAuthenticationCredentials = basicAuthenticationCredentials != null ? basicAuthenticationCredentials.build() : null;
        }

        @Override
        public final Builder basicAuthenticationCredentials(BasicAuthenticationCredentials basicAuthenticationCredentials) {
            this.basicAuthenticationCredentials = basicAuthenticationCredentials;
            return this;
        }

        public final Map<String, String> getCustomAuthenticationCredentials() {
            if (this.customAuthenticationCredentials instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customAuthenticationCredentials;
        }

        public final void setCustomAuthenticationCredentials(Map<String, String> customAuthenticationCredentials) {
            this.customAuthenticationCredentials = CredentialMapCopier.copy(customAuthenticationCredentials);
        }

        @Override
        public final Builder customAuthenticationCredentials(Map<String, String> customAuthenticationCredentials) {
            this.customAuthenticationCredentials = CredentialMapCopier.copy(customAuthenticationCredentials);
            return this;
        }

        public AuthenticationConfigurationInput build() {
            return new AuthenticationConfigurationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationConfigurationInput> {
        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder oAuth2Properties(OAuth2PropertiesInput var1);

        default public Builder oAuth2Properties(Consumer<OAuth2PropertiesInput.Builder> oAuth2Properties) {
            return this.oAuth2Properties((OAuth2PropertiesInput)((OAuth2PropertiesInput.Builder)OAuth2PropertiesInput.builder().applyMutation(oAuth2Properties)).build());
        }

        public Builder secretArn(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder basicAuthenticationCredentials(BasicAuthenticationCredentials var1);

        default public Builder basicAuthenticationCredentials(Consumer<BasicAuthenticationCredentials.Builder> basicAuthenticationCredentials) {
            return this.basicAuthenticationCredentials((BasicAuthenticationCredentials)((BasicAuthenticationCredentials.Builder)BasicAuthenticationCredentials.builder().applyMutation(basicAuthenticationCredentials)).build());
        }

        public Builder customAuthenticationCredentials(Map<String, String> var1);
    }
}

