/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ParquetCompressionType {
    SNAPPY("snappy"),
    LZO("lzo"),
    GZIP("gzip"),
    BROTLI("brotli"),
    LZ4("lz4"),
    UNCOMPRESSED("uncompressed"),
    NONE("none"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ParquetCompressionType> VALUE_MAP;
    private final String value;

    private ParquetCompressionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParquetCompressionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParquetCompressionType> knownValues() {
        EnumSet<ParquetCompressionType> knownValues = EnumSet.allOf(ParquetCompressionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ParquetCompressionType.class, ParquetCompressionType::toString);
    }
}

