/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQualityAggregatedMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQualityAggregatedMetrics> {
    private static final SdkField<Double> TOTAL_ROWS_PROCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalRowsProcessed").getter(DataQualityAggregatedMetrics.getter(DataQualityAggregatedMetrics::totalRowsProcessed)).setter(DataQualityAggregatedMetrics.setter(Builder::totalRowsProcessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRowsProcessed").build()}).build();
    private static final SdkField<Double> TOTAL_ROWS_PASSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalRowsPassed").getter(DataQualityAggregatedMetrics.getter(DataQualityAggregatedMetrics::totalRowsPassed)).setter(DataQualityAggregatedMetrics.setter(Builder::totalRowsPassed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRowsPassed").build()}).build();
    private static final SdkField<Double> TOTAL_ROWS_FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalRowsFailed").getter(DataQualityAggregatedMetrics.getter(DataQualityAggregatedMetrics::totalRowsFailed)).setter(DataQualityAggregatedMetrics.setter(Builder::totalRowsFailed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRowsFailed").build()}).build();
    private static final SdkField<Double> TOTAL_RULES_PROCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalRulesProcessed").getter(DataQualityAggregatedMetrics.getter(DataQualityAggregatedMetrics::totalRulesProcessed)).setter(DataQualityAggregatedMetrics.setter(Builder::totalRulesProcessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRulesProcessed").build()}).build();
    private static final SdkField<Double> TOTAL_RULES_PASSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalRulesPassed").getter(DataQualityAggregatedMetrics.getter(DataQualityAggregatedMetrics::totalRulesPassed)).setter(DataQualityAggregatedMetrics.setter(Builder::totalRulesPassed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRulesPassed").build()}).build();
    private static final SdkField<Double> TOTAL_RULES_FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalRulesFailed").getter(DataQualityAggregatedMetrics.getter(DataQualityAggregatedMetrics::totalRulesFailed)).setter(DataQualityAggregatedMetrics.setter(Builder::totalRulesFailed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRulesFailed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_ROWS_PROCESSED_FIELD, TOTAL_ROWS_PASSED_FIELD, TOTAL_ROWS_FAILED_FIELD, TOTAL_RULES_PROCESSED_FIELD, TOTAL_RULES_PASSED_FIELD, TOTAL_RULES_FAILED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataQualityAggregatedMetrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double totalRowsProcessed;
    private final Double totalRowsPassed;
    private final Double totalRowsFailed;
    private final Double totalRulesProcessed;
    private final Double totalRulesPassed;
    private final Double totalRulesFailed;

    private DataQualityAggregatedMetrics(BuilderImpl builder) {
        this.totalRowsProcessed = builder.totalRowsProcessed;
        this.totalRowsPassed = builder.totalRowsPassed;
        this.totalRowsFailed = builder.totalRowsFailed;
        this.totalRulesProcessed = builder.totalRulesProcessed;
        this.totalRulesPassed = builder.totalRulesPassed;
        this.totalRulesFailed = builder.totalRulesFailed;
    }

    public final Double totalRowsProcessed() {
        return this.totalRowsProcessed;
    }

    public final Double totalRowsPassed() {
        return this.totalRowsPassed;
    }

    public final Double totalRowsFailed() {
        return this.totalRowsFailed;
    }

    public final Double totalRulesProcessed() {
        return this.totalRulesProcessed;
    }

    public final Double totalRulesPassed() {
        return this.totalRulesPassed;
    }

    public final Double totalRulesFailed() {
        return this.totalRulesFailed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRowsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRowsPassed());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRowsFailed());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRulesProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRulesPassed());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRulesFailed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityAggregatedMetrics)) {
            return false;
        }
        DataQualityAggregatedMetrics other = (DataQualityAggregatedMetrics)obj;
        return Objects.equals(this.totalRowsProcessed(), other.totalRowsProcessed()) && Objects.equals(this.totalRowsPassed(), other.totalRowsPassed()) && Objects.equals(this.totalRowsFailed(), other.totalRowsFailed()) && Objects.equals(this.totalRulesProcessed(), other.totalRulesProcessed()) && Objects.equals(this.totalRulesPassed(), other.totalRulesPassed()) && Objects.equals(this.totalRulesFailed(), other.totalRulesFailed());
    }

    public final String toString() {
        return ToString.builder((String)"DataQualityAggregatedMetrics").add("TotalRowsProcessed", (Object)this.totalRowsProcessed()).add("TotalRowsPassed", (Object)this.totalRowsPassed()).add("TotalRowsFailed", (Object)this.totalRowsFailed()).add("TotalRulesProcessed", (Object)this.totalRulesProcessed()).add("TotalRulesPassed", (Object)this.totalRulesPassed()).add("TotalRulesFailed", (Object)this.totalRulesFailed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalRowsProcessed": {
                return Optional.ofNullable(clazz.cast(this.totalRowsProcessed()));
            }
            case "TotalRowsPassed": {
                return Optional.ofNullable(clazz.cast(this.totalRowsPassed()));
            }
            case "TotalRowsFailed": {
                return Optional.ofNullable(clazz.cast(this.totalRowsFailed()));
            }
            case "TotalRulesProcessed": {
                return Optional.ofNullable(clazz.cast(this.totalRulesProcessed()));
            }
            case "TotalRulesPassed": {
                return Optional.ofNullable(clazz.cast(this.totalRulesPassed()));
            }
            case "TotalRulesFailed": {
                return Optional.ofNullable(clazz.cast(this.totalRulesFailed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Double>> map = new HashMap<String, SdkField<Double>>();
        map.put("TotalRowsProcessed", TOTAL_ROWS_PROCESSED_FIELD);
        map.put("TotalRowsPassed", TOTAL_ROWS_PASSED_FIELD);
        map.put("TotalRowsFailed", TOTAL_ROWS_FAILED_FIELD);
        map.put("TotalRulesProcessed", TOTAL_RULES_PROCESSED_FIELD);
        map.put("TotalRulesPassed", TOTAL_RULES_PASSED_FIELD);
        map.put("TotalRulesFailed", TOTAL_RULES_FAILED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualityAggregatedMetrics, T> g) {
        return obj -> g.apply((DataQualityAggregatedMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double totalRowsProcessed;
        private Double totalRowsPassed;
        private Double totalRowsFailed;
        private Double totalRulesProcessed;
        private Double totalRulesPassed;
        private Double totalRulesFailed;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityAggregatedMetrics model) {
            this.totalRowsProcessed(model.totalRowsProcessed);
            this.totalRowsPassed(model.totalRowsPassed);
            this.totalRowsFailed(model.totalRowsFailed);
            this.totalRulesProcessed(model.totalRulesProcessed);
            this.totalRulesPassed(model.totalRulesPassed);
            this.totalRulesFailed(model.totalRulesFailed);
        }

        public final Double getTotalRowsProcessed() {
            return this.totalRowsProcessed;
        }

        public final void setTotalRowsProcessed(Double totalRowsProcessed) {
            this.totalRowsProcessed = totalRowsProcessed;
        }

        @Override
        public final Builder totalRowsProcessed(Double totalRowsProcessed) {
            this.totalRowsProcessed = totalRowsProcessed;
            return this;
        }

        public final Double getTotalRowsPassed() {
            return this.totalRowsPassed;
        }

        public final void setTotalRowsPassed(Double totalRowsPassed) {
            this.totalRowsPassed = totalRowsPassed;
        }

        @Override
        public final Builder totalRowsPassed(Double totalRowsPassed) {
            this.totalRowsPassed = totalRowsPassed;
            return this;
        }

        public final Double getTotalRowsFailed() {
            return this.totalRowsFailed;
        }

        public final void setTotalRowsFailed(Double totalRowsFailed) {
            this.totalRowsFailed = totalRowsFailed;
        }

        @Override
        public final Builder totalRowsFailed(Double totalRowsFailed) {
            this.totalRowsFailed = totalRowsFailed;
            return this;
        }

        public final Double getTotalRulesProcessed() {
            return this.totalRulesProcessed;
        }

        public final void setTotalRulesProcessed(Double totalRulesProcessed) {
            this.totalRulesProcessed = totalRulesProcessed;
        }

        @Override
        public final Builder totalRulesProcessed(Double totalRulesProcessed) {
            this.totalRulesProcessed = totalRulesProcessed;
            return this;
        }

        public final Double getTotalRulesPassed() {
            return this.totalRulesPassed;
        }

        public final void setTotalRulesPassed(Double totalRulesPassed) {
            this.totalRulesPassed = totalRulesPassed;
        }

        @Override
        public final Builder totalRulesPassed(Double totalRulesPassed) {
            this.totalRulesPassed = totalRulesPassed;
            return this;
        }

        public final Double getTotalRulesFailed() {
            return this.totalRulesFailed;
        }

        public final void setTotalRulesFailed(Double totalRulesFailed) {
            this.totalRulesFailed = totalRulesFailed;
        }

        @Override
        public final Builder totalRulesFailed(Double totalRulesFailed) {
            this.totalRulesFailed = totalRulesFailed;
            return this;
        }

        public DataQualityAggregatedMetrics build() {
            return new DataQualityAggregatedMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQualityAggregatedMetrics> {
        public Builder totalRowsProcessed(Double var1);

        public Builder totalRowsPassed(Double var1);

        public Builder totalRowsFailed(Double var1);

        public Builder totalRulesProcessed(Double var1);

        public Builder totalRulesPassed(Double var1);

        public Builder totalRulesFailed(Double var1);
    }
}

