/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ConnectionTypeBrief;
import software.amazon.awssdk.services.glue.model.ListConnectionTypesRequest;
import software.amazon.awssdk.services.glue.model.ListConnectionTypesResponse;

public class ListConnectionTypesIterable
implements SdkIterable<ListConnectionTypesResponse> {
    private final GlueClient client;
    private final ListConnectionTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConnectionTypesIterable(GlueClient client, ListConnectionTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConnectionTypesResponseFetcher();
    }

    public Iterator<ListConnectionTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConnectionTypeBrief> connectionTypes() {
        Function<ListConnectionTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectionTypes() != null) {
                return response.connectionTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConnectionTypesResponseFetcher
    implements SyncPageFetcher<ListConnectionTypesResponse> {
        private ListConnectionTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectionTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConnectionTypesResponse nextPage(ListConnectionTypesResponse previousPage) {
            if (previousPage == null) {
                return ListConnectionTypesIterable.this.client.listConnectionTypes(ListConnectionTypesIterable.this.firstRequest);
            }
            return ListConnectionTypesIterable.this.client.listConnectionTypes((ListConnectionTypesRequest)((Object)ListConnectionTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

