/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TriggerState {
    CREATING("CREATING"),
    CREATED("CREATED"),
    ACTIVATING("ACTIVATING"),
    ACTIVATED("ACTIVATED"),
    DEACTIVATING("DEACTIVATING"),
    DEACTIVATED("DEACTIVATED"),
    DELETING("DELETING"),
    UPDATING("UPDATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TriggerState> VALUE_MAP;
    private final String value;

    private TriggerState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TriggerState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TriggerState> knownValues() {
        EnumSet<TriggerState> knownValues = EnumSet.allOf(TriggerState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TriggerState.class, TriggerState::toString);
    }
}

