/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OAuth2Credentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OAuth2Credentials> {
    private static final SdkField<String> USER_MANAGED_CLIENT_APPLICATION_CLIENT_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserManagedClientApplicationClientSecret").getter(OAuth2Credentials.getter(OAuth2Credentials::userManagedClientApplicationClientSecret)).setter(OAuth2Credentials.setter(Builder::userManagedClientApplicationClientSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserManagedClientApplicationClientSecret").build()}).build();
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessToken").getter(OAuth2Credentials.getter(OAuth2Credentials::accessToken)).setter(OAuth2Credentials.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessToken").build()}).build();
    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RefreshToken").getter(OAuth2Credentials.getter(OAuth2Credentials::refreshToken)).setter(OAuth2Credentials.setter(Builder::refreshToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshToken").build()}).build();
    private static final SdkField<String> JWT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JwtToken").getter(OAuth2Credentials.getter(OAuth2Credentials::jwtToken)).setter(OAuth2Credentials.setter(Builder::jwtToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwtToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_MANAGED_CLIENT_APPLICATION_CLIENT_SECRET_FIELD, ACCESS_TOKEN_FIELD, REFRESH_TOKEN_FIELD, JWT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OAuth2Credentials.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String userManagedClientApplicationClientSecret;
    private final String accessToken;
    private final String refreshToken;
    private final String jwtToken;

    private OAuth2Credentials(BuilderImpl builder) {
        this.userManagedClientApplicationClientSecret = builder.userManagedClientApplicationClientSecret;
        this.accessToken = builder.accessToken;
        this.refreshToken = builder.refreshToken;
        this.jwtToken = builder.jwtToken;
    }

    public final String userManagedClientApplicationClientSecret() {
        return this.userManagedClientApplicationClientSecret;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final String refreshToken() {
        return this.refreshToken;
    }

    public final String jwtToken() {
        return this.jwtToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userManagedClientApplicationClientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.jwtToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2Credentials)) {
            return false;
        }
        OAuth2Credentials other = (OAuth2Credentials)obj;
        return Objects.equals(this.userManagedClientApplicationClientSecret(), other.userManagedClientApplicationClientSecret()) && Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.refreshToken(), other.refreshToken()) && Objects.equals(this.jwtToken(), other.jwtToken());
    }

    public final String toString() {
        return ToString.builder((String)"OAuth2Credentials").add("UserManagedClientApplicationClientSecret", (Object)(this.userManagedClientApplicationClientSecret() == null ? null : "*** Sensitive Data Redacted ***")).add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("RefreshToken", (Object)(this.refreshToken() == null ? null : "*** Sensitive Data Redacted ***")).add("JwtToken", (Object)(this.jwtToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserManagedClientApplicationClientSecret": {
                return Optional.ofNullable(clazz.cast(this.userManagedClientApplicationClientSecret()));
            }
            case "AccessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "RefreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
            case "JwtToken": {
                return Optional.ofNullable(clazz.cast(this.jwtToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("UserManagedClientApplicationClientSecret", USER_MANAGED_CLIENT_APPLICATION_CLIENT_SECRET_FIELD);
        map.put("AccessToken", ACCESS_TOKEN_FIELD);
        map.put("RefreshToken", REFRESH_TOKEN_FIELD);
        map.put("JwtToken", JWT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuth2Credentials, T> g) {
        return obj -> g.apply((OAuth2Credentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userManagedClientApplicationClientSecret;
        private String accessToken;
        private String refreshToken;
        private String jwtToken;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2Credentials model) {
            this.userManagedClientApplicationClientSecret(model.userManagedClientApplicationClientSecret);
            this.accessToken(model.accessToken);
            this.refreshToken(model.refreshToken);
            this.jwtToken(model.jwtToken);
        }

        public final String getUserManagedClientApplicationClientSecret() {
            return this.userManagedClientApplicationClientSecret;
        }

        public final void setUserManagedClientApplicationClientSecret(String userManagedClientApplicationClientSecret) {
            this.userManagedClientApplicationClientSecret = userManagedClientApplicationClientSecret;
        }

        @Override
        public final Builder userManagedClientApplicationClientSecret(String userManagedClientApplicationClientSecret) {
            this.userManagedClientApplicationClientSecret = userManagedClientApplicationClientSecret;
            return this;
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final String getJwtToken() {
            return this.jwtToken;
        }

        public final void setJwtToken(String jwtToken) {
            this.jwtToken = jwtToken;
        }

        @Override
        public final Builder jwtToken(String jwtToken) {
            this.jwtToken = jwtToken;
            return this;
        }

        public OAuth2Credentials build() {
            return new OAuth2Credentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OAuth2Credentials> {
        public Builder userManagedClientApplicationClientSecret(String var1);

        public Builder accessToken(String var1);

        public Builder refreshToken(String var1);

        public Builder jwtToken(String var1);
    }
}

