/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.SearchTablesRequest;
import software.amazon.awssdk.services.glue.model.SearchTablesResponse;

public class SearchTablesIterable
implements SdkIterable<SearchTablesResponse> {
    private final GlueClient client;
    private final SearchTablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchTablesIterable(GlueClient client, SearchTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchTablesResponseFetcher();
    }

    public Iterator<SearchTablesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class SearchTablesResponseFetcher
    implements SyncPageFetcher<SearchTablesResponse> {
        private SearchTablesResponseFetcher() {
        }

        public boolean hasNextPage(SearchTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchTablesResponse nextPage(SearchTablesResponse previousPage) {
            if (previousPage == null) {
                return SearchTablesIterable.this.client.searchTables(SearchTablesIterable.this.firstRequest);
            }
            return SearchTablesIterable.this.client.searchTables((SearchTablesRequest)((Object)SearchTablesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

