/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.ViewDialect;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ViewRepresentation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ViewRepresentation> {
    private static final SdkField<String> DIALECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Dialect").getter(ViewRepresentation.getter(ViewRepresentation::dialectAsString)).setter(ViewRepresentation.setter(Builder::dialect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dialect").build()}).build();
    private static final SdkField<String> DIALECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DialectVersion").getter(ViewRepresentation.getter(ViewRepresentation::dialectVersion)).setter(ViewRepresentation.setter(Builder::dialectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DialectVersion").build()}).build();
    private static final SdkField<String> VIEW_ORIGINAL_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewOriginalText").getter(ViewRepresentation.getter(ViewRepresentation::viewOriginalText)).setter(ViewRepresentation.setter(Builder::viewOriginalText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewOriginalText").build()}).build();
    private static final SdkField<String> VIEW_EXPANDED_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewExpandedText").getter(ViewRepresentation.getter(ViewRepresentation::viewExpandedText)).setter(ViewRepresentation.setter(Builder::viewExpandedText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewExpandedText").build()}).build();
    private static final SdkField<Boolean> IS_STALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsStale").getter(ViewRepresentation.getter(ViewRepresentation::isStale)).setter(ViewRepresentation.setter(Builder::isStale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsStale").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIALECT_FIELD, DIALECT_VERSION_FIELD, VIEW_ORIGINAL_TEXT_FIELD, VIEW_EXPANDED_TEXT_FIELD, IS_STALE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dialect;
    private final String dialectVersion;
    private final String viewOriginalText;
    private final String viewExpandedText;
    private final Boolean isStale;

    private ViewRepresentation(BuilderImpl builder) {
        this.dialect = builder.dialect;
        this.dialectVersion = builder.dialectVersion;
        this.viewOriginalText = builder.viewOriginalText;
        this.viewExpandedText = builder.viewExpandedText;
        this.isStale = builder.isStale;
    }

    public final ViewDialect dialect() {
        return ViewDialect.fromValue(this.dialect);
    }

    public final String dialectAsString() {
        return this.dialect;
    }

    public final String dialectVersion() {
        return this.dialectVersion;
    }

    public final String viewOriginalText() {
        return this.viewOriginalText;
    }

    public final String viewExpandedText() {
        return this.viewExpandedText;
    }

    public final Boolean isStale() {
        return this.isStale;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dialectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewOriginalText());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewExpandedText());
        hashCode = 31 * hashCode + Objects.hashCode(this.isStale());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewRepresentation)) {
            return false;
        }
        ViewRepresentation other = (ViewRepresentation)obj;
        return Objects.equals(this.dialectAsString(), other.dialectAsString()) && Objects.equals(this.dialectVersion(), other.dialectVersion()) && Objects.equals(this.viewOriginalText(), other.viewOriginalText()) && Objects.equals(this.viewExpandedText(), other.viewExpandedText()) && Objects.equals(this.isStale(), other.isStale());
    }

    public final String toString() {
        return ToString.builder((String)"ViewRepresentation").add("Dialect", (Object)this.dialectAsString()).add("DialectVersion", (Object)this.dialectVersion()).add("ViewOriginalText", (Object)this.viewOriginalText()).add("ViewExpandedText", (Object)this.viewExpandedText()).add("IsStale", (Object)this.isStale()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dialect": {
                return Optional.ofNullable(clazz.cast(this.dialectAsString()));
            }
            case "DialectVersion": {
                return Optional.ofNullable(clazz.cast(this.dialectVersion()));
            }
            case "ViewOriginalText": {
                return Optional.ofNullable(clazz.cast(this.viewOriginalText()));
            }
            case "ViewExpandedText": {
                return Optional.ofNullable(clazz.cast(this.viewExpandedText()));
            }
            case "IsStale": {
                return Optional.ofNullable(clazz.cast(this.isStale()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ViewRepresentation, T> g) {
        return obj -> g.apply((ViewRepresentation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dialect;
        private String dialectVersion;
        private String viewOriginalText;
        private String viewExpandedText;
        private Boolean isStale;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewRepresentation model) {
            this.dialect(model.dialect);
            this.dialectVersion(model.dialectVersion);
            this.viewOriginalText(model.viewOriginalText);
            this.viewExpandedText(model.viewExpandedText);
            this.isStale(model.isStale);
        }

        public final String getDialect() {
            return this.dialect;
        }

        public final void setDialect(String dialect) {
            this.dialect = dialect;
        }

        @Override
        public final Builder dialect(String dialect) {
            this.dialect = dialect;
            return this;
        }

        @Override
        public final Builder dialect(ViewDialect dialect) {
            this.dialect(dialect == null ? null : dialect.toString());
            return this;
        }

        public final String getDialectVersion() {
            return this.dialectVersion;
        }

        public final void setDialectVersion(String dialectVersion) {
            this.dialectVersion = dialectVersion;
        }

        @Override
        public final Builder dialectVersion(String dialectVersion) {
            this.dialectVersion = dialectVersion;
            return this;
        }

        public final String getViewOriginalText() {
            return this.viewOriginalText;
        }

        public final void setViewOriginalText(String viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
        }

        @Override
        public final Builder viewOriginalText(String viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
            return this;
        }

        public final String getViewExpandedText() {
            return this.viewExpandedText;
        }

        public final void setViewExpandedText(String viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
        }

        @Override
        public final Builder viewExpandedText(String viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
            return this;
        }

        public final Boolean getIsStale() {
            return this.isStale;
        }

        public final void setIsStale(Boolean isStale) {
            this.isStale = isStale;
        }

        @Override
        public final Builder isStale(Boolean isStale) {
            this.isStale = isStale;
            return this;
        }

        public ViewRepresentation build() {
            return new ViewRepresentation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ViewRepresentation> {
        public Builder dialect(String var1);

        public Builder dialect(ViewDialect var1);

        public Builder dialectVersion(String var1);

        public Builder viewOriginalText(String var1);

        public Builder viewExpandedText(String var1);

        public Builder isStale(Boolean var1);
    }
}

