/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details for a table optimizer run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableOptimizerRun implements SdkPojo, Serializable,
        ToCopyableBuilder<TableOptimizerRun.Builder, TableOptimizerRun> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(TableOptimizerRun::eventTypeAsString)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTimestamp").getter(getter(TableOptimizerRun::startTimestamp))
            .setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimestamp").build()).build();

    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTimestamp").getter(getter(TableOptimizerRun::endTimestamp)).setter(setter(Builder::endTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimestamp").build()).build();

    private static final SdkField<RunMetrics> METRICS_FIELD = SdkField.<RunMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("metrics").getter(getter(TableOptimizerRun::metrics)).setter(setter(Builder::metrics))
            .constructor(RunMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(TableOptimizerRun::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD,
            START_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD, METRICS_FIELD, ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String eventType;

    private final Instant startTimestamp;

    private final Instant endTimestamp;

    private final RunMetrics metrics;

    private final String error;

    private TableOptimizerRun(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.metrics = builder.metrics;
        this.error = builder.error;
    }

    /**
     * <p>
     * An event type representing the status of the table optimizer run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link TableOptimizerEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return An event type representing the status of the table optimizer run.
     * @see TableOptimizerEventType
     */
    public final TableOptimizerEventType eventType() {
        return TableOptimizerEventType.fromValue(eventType);
    }

    /**
     * <p>
     * An event type representing the status of the table optimizer run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link TableOptimizerEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return An event type representing the status of the table optimizer run.
     * @see TableOptimizerEventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * Represents the epoch timestamp at which the compaction job was started within Lake Formation.
     * </p>
     * 
     * @return Represents the epoch timestamp at which the compaction job was started within Lake Formation.
     */
    public final Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * Represents the epoch timestamp at which the compaction job ended.
     * </p>
     * 
     * @return Represents the epoch timestamp at which the compaction job ended.
     */
    public final Instant endTimestamp() {
        return endTimestamp;
    }

    /**
     * <p>
     * A <code>RunMetrics</code> object containing metrics for the optimizer run.
     * </p>
     * 
     * @return A <code>RunMetrics</code> object containing metrics for the optimizer run.
     */
    public final RunMetrics metrics() {
        return metrics;
    }

    /**
     * <p>
     * An error that occured during the optimizer run.
     * </p>
     * 
     * @return An error that occured during the optimizer run.
     */
    public final String error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableOptimizerRun)) {
            return false;
        }
        TableOptimizerRun other = (TableOptimizerRun) obj;
        return Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(startTimestamp(), other.startTimestamp())
                && Objects.equals(endTimestamp(), other.endTimestamp()) && Objects.equals(metrics(), other.metrics())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableOptimizerRun").add("EventType", eventTypeAsString())
                .add("StartTimestamp", startTimestamp()).add("EndTimestamp", endTimestamp()).add("Metrics", metrics())
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "startTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "endTimestamp":
            return Optional.ofNullable(clazz.cast(endTimestamp()));
        case "metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableOptimizerRun, T> g) {
        return obj -> g.apply((TableOptimizerRun) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableOptimizerRun> {
        /**
         * <p>
         * An event type representing the status of the table optimizer run.
         * </p>
         * 
         * @param eventType
         *        An event type representing the status of the table optimizer run.
         * @see TableOptimizerEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableOptimizerEventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * An event type representing the status of the table optimizer run.
         * </p>
         * 
         * @param eventType
         *        An event type representing the status of the table optimizer run.
         * @see TableOptimizerEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TableOptimizerEventType
         */
        Builder eventType(TableOptimizerEventType eventType);

        /**
         * <p>
         * Represents the epoch timestamp at which the compaction job was started within Lake Formation.
         * </p>
         * 
         * @param startTimestamp
         *        Represents the epoch timestamp at which the compaction job was started within Lake Formation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * Represents the epoch timestamp at which the compaction job ended.
         * </p>
         * 
         * @param endTimestamp
         *        Represents the epoch timestamp at which the compaction job ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimestamp(Instant endTimestamp);

        /**
         * <p>
         * A <code>RunMetrics</code> object containing metrics for the optimizer run.
         * </p>
         * 
         * @param metrics
         *        A <code>RunMetrics</code> object containing metrics for the optimizer run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(RunMetrics metrics);

        /**
         * <p>
         * A <code>RunMetrics</code> object containing metrics for the optimizer run.
         * </p>
         * This is a convenience method that creates an instance of the {@link RunMetrics.Builder} avoiding the need to
         * create one manually via {@link RunMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RunMetrics.Builder#build()} is called immediately and its result
         * is passed to {@link #metrics(RunMetrics)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link RunMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(RunMetrics)
         */
        default Builder metrics(Consumer<RunMetrics.Builder> metrics) {
            return metrics(RunMetrics.builder().applyMutation(metrics).build());
        }

        /**
         * <p>
         * An error that occured during the optimizer run.
         * </p>
         * 
         * @param error
         *        An error that occured during the optimizer run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);
    }

    static final class BuilderImpl implements Builder {
        private String eventType;

        private Instant startTimestamp;

        private Instant endTimestamp;

        private RunMetrics metrics;

        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(TableOptimizerRun model) {
            eventType(model.eventType);
            startTimestamp(model.startTimestamp);
            endTimestamp(model.endTimestamp);
            metrics(model.metrics);
            error(model.error);
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(TableOptimizerEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final RunMetrics.Builder getMetrics() {
            return metrics != null ? metrics.toBuilder() : null;
        }

        public final void setMetrics(RunMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(RunMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public TableOptimizerRun build() {
            return new TableOptimizerRun(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
