/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines column statistics supported for character sequence data values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StringColumnStatisticsData implements SdkPojo, Serializable,
        ToCopyableBuilder<StringColumnStatisticsData.Builder, StringColumnStatisticsData> {
    private static final SdkField<Long> MAXIMUM_LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaximumLength").getter(getter(StringColumnStatisticsData::maximumLength))
            .setter(setter(Builder::maximumLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumLength").build()).build();

    private static final SdkField<Double> AVERAGE_LENGTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("AverageLength").getter(getter(StringColumnStatisticsData::averageLength))
            .setter(setter(Builder::averageLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageLength").build()).build();

    private static final SdkField<Long> NUMBER_OF_NULLS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfNulls").getter(getter(StringColumnStatisticsData::numberOfNulls))
            .setter(setter(Builder::numberOfNulls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNulls").build()).build();

    private static final SdkField<Long> NUMBER_OF_DISTINCT_VALUES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfDistinctValues").getter(getter(StringColumnStatisticsData::numberOfDistinctValues))
            .setter(setter(Builder::numberOfDistinctValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDistinctValues").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_LENGTH_FIELD,
            AVERAGE_LENGTH_FIELD, NUMBER_OF_NULLS_FIELD, NUMBER_OF_DISTINCT_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long maximumLength;

    private final Double averageLength;

    private final Long numberOfNulls;

    private final Long numberOfDistinctValues;

    private StringColumnStatisticsData(BuilderImpl builder) {
        this.maximumLength = builder.maximumLength;
        this.averageLength = builder.averageLength;
        this.numberOfNulls = builder.numberOfNulls;
        this.numberOfDistinctValues = builder.numberOfDistinctValues;
    }

    /**
     * <p>
     * The size of the longest string in the column.
     * </p>
     * 
     * @return The size of the longest string in the column.
     */
    public final Long maximumLength() {
        return maximumLength;
    }

    /**
     * <p>
     * The average string length in the column.
     * </p>
     * 
     * @return The average string length in the column.
     */
    public final Double averageLength() {
        return averageLength;
    }

    /**
     * <p>
     * The number of null values in the column.
     * </p>
     * 
     * @return The number of null values in the column.
     */
    public final Long numberOfNulls() {
        return numberOfNulls;
    }

    /**
     * <p>
     * The number of distinct values in a column.
     * </p>
     * 
     * @return The number of distinct values in a column.
     */
    public final Long numberOfDistinctValues() {
        return numberOfDistinctValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumLength());
        hashCode = 31 * hashCode + Objects.hashCode(averageLength());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNulls());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDistinctValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringColumnStatisticsData)) {
            return false;
        }
        StringColumnStatisticsData other = (StringColumnStatisticsData) obj;
        return Objects.equals(maximumLength(), other.maximumLength()) && Objects.equals(averageLength(), other.averageLength())
                && Objects.equals(numberOfNulls(), other.numberOfNulls())
                && Objects.equals(numberOfDistinctValues(), other.numberOfDistinctValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StringColumnStatisticsData").add("MaximumLength", maximumLength())
                .add("AverageLength", averageLength()).add("NumberOfNulls", numberOfNulls())
                .add("NumberOfDistinctValues", numberOfDistinctValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumLength":
            return Optional.ofNullable(clazz.cast(maximumLength()));
        case "AverageLength":
            return Optional.ofNullable(clazz.cast(averageLength()));
        case "NumberOfNulls":
            return Optional.ofNullable(clazz.cast(numberOfNulls()));
        case "NumberOfDistinctValues":
            return Optional.ofNullable(clazz.cast(numberOfDistinctValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StringColumnStatisticsData, T> g) {
        return obj -> g.apply((StringColumnStatisticsData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StringColumnStatisticsData> {
        /**
         * <p>
         * The size of the longest string in the column.
         * </p>
         * 
         * @param maximumLength
         *        The size of the longest string in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumLength(Long maximumLength);

        /**
         * <p>
         * The average string length in the column.
         * </p>
         * 
         * @param averageLength
         *        The average string length in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageLength(Double averageLength);

        /**
         * <p>
         * The number of null values in the column.
         * </p>
         * 
         * @param numberOfNulls
         *        The number of null values in the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNulls(Long numberOfNulls);

        /**
         * <p>
         * The number of distinct values in a column.
         * </p>
         * 
         * @param numberOfDistinctValues
         *        The number of distinct values in a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDistinctValues(Long numberOfDistinctValues);
    }

    static final class BuilderImpl implements Builder {
        private Long maximumLength;

        private Double averageLength;

        private Long numberOfNulls;

        private Long numberOfDistinctValues;

        private BuilderImpl() {
        }

        private BuilderImpl(StringColumnStatisticsData model) {
            maximumLength(model.maximumLength);
            averageLength(model.averageLength);
            numberOfNulls(model.numberOfNulls);
            numberOfDistinctValues(model.numberOfDistinctValues);
        }

        public final Long getMaximumLength() {
            return maximumLength;
        }

        public final void setMaximumLength(Long maximumLength) {
            this.maximumLength = maximumLength;
        }

        @Override
        public final Builder maximumLength(Long maximumLength) {
            this.maximumLength = maximumLength;
            return this;
        }

        public final Double getAverageLength() {
            return averageLength;
        }

        public final void setAverageLength(Double averageLength) {
            this.averageLength = averageLength;
        }

        @Override
        public final Builder averageLength(Double averageLength) {
            this.averageLength = averageLength;
            return this;
        }

        public final Long getNumberOfNulls() {
            return numberOfNulls;
        }

        public final void setNumberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
        }

        @Override
        public final Builder numberOfNulls(Long numberOfNulls) {
            this.numberOfNulls = numberOfNulls;
            return this;
        }

        public final Long getNumberOfDistinctValues() {
            return numberOfDistinctValues;
        }

        public final void setNumberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
        }

        @Override
        public final Builder numberOfDistinctValues(Long numberOfDistinctValues) {
            this.numberOfDistinctValues = numberOfDistinctValues;
            return this;
        }

        @Override
        public StringColumnStatisticsData build() {
            return new StringColumnStatisticsData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
