/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional connection options for the connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JDBCConnectorOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<JDBCConnectorOptions.Builder, JDBCConnectorOptions> {
    private static final SdkField<String> FILTER_PREDICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterPredicate").getter(getter(JDBCConnectorOptions::filterPredicate))
            .setter(setter(Builder::filterPredicate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterPredicate").build()).build();

    private static final SdkField<String> PARTITION_COLUMN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartitionColumn").getter(getter(JDBCConnectorOptions::partitionColumn))
            .setter(setter(Builder::partitionColumn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionColumn").build()).build();

    private static final SdkField<Long> LOWER_BOUND_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LowerBound").getter(getter(JDBCConnectorOptions::lowerBound)).setter(setter(Builder::lowerBound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowerBound").build()).build();

    private static final SdkField<Long> UPPER_BOUND_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("UpperBound").getter(getter(JDBCConnectorOptions::upperBound)).setter(setter(Builder::upperBound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpperBound").build()).build();

    private static final SdkField<Long> NUM_PARTITIONS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumPartitions").getter(getter(JDBCConnectorOptions::numPartitions))
            .setter(setter(Builder::numPartitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumPartitions").build()).build();

    private static final SdkField<List<String>> JOB_BOOKMARK_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("JobBookmarkKeys")
            .getter(getter(JDBCConnectorOptions::jobBookmarkKeys))
            .setter(setter(Builder::jobBookmarkKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobBookmarkKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> JOB_BOOKMARK_KEYS_SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobBookmarkKeysSortOrder").getter(getter(JDBCConnectorOptions::jobBookmarkKeysSortOrder))
            .setter(setter(Builder::jobBookmarkKeysSortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobBookmarkKeysSortOrder").build())
            .build();

    private static final SdkField<Map<String, String>> DATA_TYPE_MAPPING_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DataTypeMapping")
            .getter(getter(JDBCConnectorOptions::dataTypeMappingAsStrings))
            .setter(setter(Builder::dataTypeMappingWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTypeMapping").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_PREDICATE_FIELD,
            PARTITION_COLUMN_FIELD, LOWER_BOUND_FIELD, UPPER_BOUND_FIELD, NUM_PARTITIONS_FIELD, JOB_BOOKMARK_KEYS_FIELD,
            JOB_BOOKMARK_KEYS_SORT_ORDER_FIELD, DATA_TYPE_MAPPING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filterPredicate;

    private final String partitionColumn;

    private final Long lowerBound;

    private final Long upperBound;

    private final Long numPartitions;

    private final List<String> jobBookmarkKeys;

    private final String jobBookmarkKeysSortOrder;

    private final Map<String, String> dataTypeMapping;

    private JDBCConnectorOptions(BuilderImpl builder) {
        this.filterPredicate = builder.filterPredicate;
        this.partitionColumn = builder.partitionColumn;
        this.lowerBound = builder.lowerBound;
        this.upperBound = builder.upperBound;
        this.numPartitions = builder.numPartitions;
        this.jobBookmarkKeys = builder.jobBookmarkKeys;
        this.jobBookmarkKeysSortOrder = builder.jobBookmarkKeysSortOrder;
        this.dataTypeMapping = builder.dataTypeMapping;
    }

    /**
     * <p>
     * Extra condition clause to filter data from source. For example:
     * </p>
     * <p>
     * <code>BillingCity='Mountain View'</code>
     * </p>
     * <p>
     * When using a query instead of a table name, you should validate that the query works with the specified
     * <code>filterPredicate</code>.
     * </p>
     * 
     * @return Extra condition clause to filter data from source. For example:</p>
     *         <p>
     *         <code>BillingCity='Mountain View'</code>
     *         </p>
     *         <p>
     *         When using a query instead of a table name, you should validate that the query works with the specified
     *         <code>filterPredicate</code>.
     */
    public final String filterPredicate() {
        return filterPredicate;
    }

    /**
     * <p>
     * The name of an integer column that is used for partitioning. This option works only when it's included with
     * <code>lowerBound</code>, <code>upperBound</code>, and <code>numPartitions</code>. This option works the same way
     * as in the Spark SQL JDBC reader.
     * </p>
     * 
     * @return The name of an integer column that is used for partitioning. This option works only when it's included
     *         with <code>lowerBound</code>, <code>upperBound</code>, and <code>numPartitions</code>. This option works
     *         the same way as in the Spark SQL JDBC reader.
     */
    public final String partitionColumn() {
        return partitionColumn;
    }

    /**
     * <p>
     * The minimum value of <code>partitionColumn</code> that is used to decide partition stride.
     * </p>
     * 
     * @return The minimum value of <code>partitionColumn</code> that is used to decide partition stride.
     */
    public final Long lowerBound() {
        return lowerBound;
    }

    /**
     * <p>
     * The maximum value of <code>partitionColumn</code> that is used to decide partition stride.
     * </p>
     * 
     * @return The maximum value of <code>partitionColumn</code> that is used to decide partition stride.
     */
    public final Long upperBound() {
        return upperBound;
    }

    /**
     * <p>
     * The number of partitions. This value, along with <code>lowerBound</code> (inclusive) and <code>upperBound</code>
     * (exclusive), form partition strides for generated <code>WHERE</code> clause expressions that are used to split
     * the <code>partitionColumn</code>.
     * </p>
     * 
     * @return The number of partitions. This value, along with <code>lowerBound</code> (inclusive) and
     *         <code>upperBound</code> (exclusive), form partition strides for generated <code>WHERE</code> clause
     *         expressions that are used to split the <code>partitionColumn</code>.
     */
    public final Long numPartitions() {
        return numPartitions;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobBookmarkKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasJobBookmarkKeys() {
        return jobBookmarkKeys != null && !(jobBookmarkKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the job bookmark keys on which to sort.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobBookmarkKeys} method.
     * </p>
     * 
     * @return The name of the job bookmark keys on which to sort.
     */
    public final List<String> jobBookmarkKeys() {
        return jobBookmarkKeys;
    }

    /**
     * <p>
     * Specifies an ascending or descending sort order.
     * </p>
     * 
     * @return Specifies an ascending or descending sort order.
     */
    public final String jobBookmarkKeysSortOrder() {
        return jobBookmarkKeysSortOrder;
    }

    /**
     * <p>
     * Custom data type mapping that builds a mapping from a JDBC data type to an Glue data type. For example, the
     * option <code>"dataTypeMapping":{"FLOAT":"STRING"}</code> maps data fields of JDBC type <code>FLOAT</code> into
     * the Java <code>String</code> type by calling the <code>ResultSet.getString()</code> method of the driver, and
     * uses it to build the Glue record. The <code>ResultSet</code> object is implemented by each driver, so the
     * behavior is specific to the driver you use. Refer to the documentation for your JDBC driver to understand how the
     * driver performs the conversions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataTypeMapping} method.
     * </p>
     * 
     * @return Custom data type mapping that builds a mapping from a JDBC data type to an Glue data type. For example,
     *         the option <code>"dataTypeMapping":{"FLOAT":"STRING"}</code> maps data fields of JDBC type
     *         <code>FLOAT</code> into the Java <code>String</code> type by calling the
     *         <code>ResultSet.getString()</code> method of the driver, and uses it to build the Glue record. The
     *         <code>ResultSet</code> object is implemented by each driver, so the behavior is specific to the driver
     *         you use. Refer to the documentation for your JDBC driver to understand how the driver performs the
     *         conversions.
     */
    public final Map<JDBCDataType, GlueRecordType> dataTypeMapping() {
        return JDBCDataTypeMappingCopier.copyStringToEnum(dataTypeMapping);
    }

    /**
     * For responses, this returns true if the service returned a value for the DataTypeMapping property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataTypeMapping() {
        return dataTypeMapping != null && !(dataTypeMapping instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Custom data type mapping that builds a mapping from a JDBC data type to an Glue data type. For example, the
     * option <code>"dataTypeMapping":{"FLOAT":"STRING"}</code> maps data fields of JDBC type <code>FLOAT</code> into
     * the Java <code>String</code> type by calling the <code>ResultSet.getString()</code> method of the driver, and
     * uses it to build the Glue record. The <code>ResultSet</code> object is implemented by each driver, so the
     * behavior is specific to the driver you use. Refer to the documentation for your JDBC driver to understand how the
     * driver performs the conversions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataTypeMapping} method.
     * </p>
     * 
     * @return Custom data type mapping that builds a mapping from a JDBC data type to an Glue data type. For example,
     *         the option <code>"dataTypeMapping":{"FLOAT":"STRING"}</code> maps data fields of JDBC type
     *         <code>FLOAT</code> into the Java <code>String</code> type by calling the
     *         <code>ResultSet.getString()</code> method of the driver, and uses it to build the Glue record. The
     *         <code>ResultSet</code> object is implemented by each driver, so the behavior is specific to the driver
     *         you use. Refer to the documentation for your JDBC driver to understand how the driver performs the
     *         conversions.
     */
    public final Map<String, String> dataTypeMappingAsStrings() {
        return dataTypeMapping;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterPredicate());
        hashCode = 31 * hashCode + Objects.hashCode(partitionColumn());
        hashCode = 31 * hashCode + Objects.hashCode(lowerBound());
        hashCode = 31 * hashCode + Objects.hashCode(upperBound());
        hashCode = 31 * hashCode + Objects.hashCode(numPartitions());
        hashCode = 31 * hashCode + Objects.hashCode(hasJobBookmarkKeys() ? jobBookmarkKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(jobBookmarkKeysSortOrder());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataTypeMapping() ? dataTypeMappingAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JDBCConnectorOptions)) {
            return false;
        }
        JDBCConnectorOptions other = (JDBCConnectorOptions) obj;
        return Objects.equals(filterPredicate(), other.filterPredicate())
                && Objects.equals(partitionColumn(), other.partitionColumn()) && Objects.equals(lowerBound(), other.lowerBound())
                && Objects.equals(upperBound(), other.upperBound()) && Objects.equals(numPartitions(), other.numPartitions())
                && hasJobBookmarkKeys() == other.hasJobBookmarkKeys()
                && Objects.equals(jobBookmarkKeys(), other.jobBookmarkKeys())
                && Objects.equals(jobBookmarkKeysSortOrder(), other.jobBookmarkKeysSortOrder())
                && hasDataTypeMapping() == other.hasDataTypeMapping()
                && Objects.equals(dataTypeMappingAsStrings(), other.dataTypeMappingAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JDBCConnectorOptions").add("FilterPredicate", filterPredicate())
                .add("PartitionColumn", partitionColumn()).add("LowerBound", lowerBound()).add("UpperBound", upperBound())
                .add("NumPartitions", numPartitions()).add("JobBookmarkKeys", hasJobBookmarkKeys() ? jobBookmarkKeys() : null)
                .add("JobBookmarkKeysSortOrder", jobBookmarkKeysSortOrder())
                .add("DataTypeMapping", hasDataTypeMapping() ? dataTypeMappingAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterPredicate":
            return Optional.ofNullable(clazz.cast(filterPredicate()));
        case "PartitionColumn":
            return Optional.ofNullable(clazz.cast(partitionColumn()));
        case "LowerBound":
            return Optional.ofNullable(clazz.cast(lowerBound()));
        case "UpperBound":
            return Optional.ofNullable(clazz.cast(upperBound()));
        case "NumPartitions":
            return Optional.ofNullable(clazz.cast(numPartitions()));
        case "JobBookmarkKeys":
            return Optional.ofNullable(clazz.cast(jobBookmarkKeys()));
        case "JobBookmarkKeysSortOrder":
            return Optional.ofNullable(clazz.cast(jobBookmarkKeysSortOrder()));
        case "DataTypeMapping":
            return Optional.ofNullable(clazz.cast(dataTypeMappingAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JDBCConnectorOptions, T> g) {
        return obj -> g.apply((JDBCConnectorOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JDBCConnectorOptions> {
        /**
         * <p>
         * Extra condition clause to filter data from source. For example:
         * </p>
         * <p>
         * <code>BillingCity='Mountain View'</code>
         * </p>
         * <p>
         * When using a query instead of a table name, you should validate that the query works with the specified
         * <code>filterPredicate</code>.
         * </p>
         * 
         * @param filterPredicate
         *        Extra condition clause to filter data from source. For example:</p>
         *        <p>
         *        <code>BillingCity='Mountain View'</code>
         *        </p>
         *        <p>
         *        When using a query instead of a table name, you should validate that the query works with the
         *        specified <code>filterPredicate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPredicate(String filterPredicate);

        /**
         * <p>
         * The name of an integer column that is used for partitioning. This option works only when it's included with
         * <code>lowerBound</code>, <code>upperBound</code>, and <code>numPartitions</code>. This option works the same
         * way as in the Spark SQL JDBC reader.
         * </p>
         * 
         * @param partitionColumn
         *        The name of an integer column that is used for partitioning. This option works only when it's included
         *        with <code>lowerBound</code>, <code>upperBound</code>, and <code>numPartitions</code>. This option
         *        works the same way as in the Spark SQL JDBC reader.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionColumn(String partitionColumn);

        /**
         * <p>
         * The minimum value of <code>partitionColumn</code> that is used to decide partition stride.
         * </p>
         * 
         * @param lowerBound
         *        The minimum value of <code>partitionColumn</code> that is used to decide partition stride.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowerBound(Long lowerBound);

        /**
         * <p>
         * The maximum value of <code>partitionColumn</code> that is used to decide partition stride.
         * </p>
         * 
         * @param upperBound
         *        The maximum value of <code>partitionColumn</code> that is used to decide partition stride.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upperBound(Long upperBound);

        /**
         * <p>
         * The number of partitions. This value, along with <code>lowerBound</code> (inclusive) and
         * <code>upperBound</code> (exclusive), form partition strides for generated <code>WHERE</code> clause
         * expressions that are used to split the <code>partitionColumn</code>.
         * </p>
         * 
         * @param numPartitions
         *        The number of partitions. This value, along with <code>lowerBound</code> (inclusive) and
         *        <code>upperBound</code> (exclusive), form partition strides for generated <code>WHERE</code> clause
         *        expressions that are used to split the <code>partitionColumn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numPartitions(Long numPartitions);

        /**
         * <p>
         * The name of the job bookmark keys on which to sort.
         * </p>
         * 
         * @param jobBookmarkKeys
         *        The name of the job bookmark keys on which to sort.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobBookmarkKeys(Collection<String> jobBookmarkKeys);

        /**
         * <p>
         * The name of the job bookmark keys on which to sort.
         * </p>
         * 
         * @param jobBookmarkKeys
         *        The name of the job bookmark keys on which to sort.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobBookmarkKeys(String... jobBookmarkKeys);

        /**
         * <p>
         * Specifies an ascending or descending sort order.
         * </p>
         * 
         * @param jobBookmarkKeysSortOrder
         *        Specifies an ascending or descending sort order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobBookmarkKeysSortOrder(String jobBookmarkKeysSortOrder);

        /**
         * <p>
         * Custom data type mapping that builds a mapping from a JDBC data type to an Glue data type. For example, the
         * option <code>"dataTypeMapping":{"FLOAT":"STRING"}</code> maps data fields of JDBC type <code>FLOAT</code>
         * into the Java <code>String</code> type by calling the <code>ResultSet.getString()</code> method of the
         * driver, and uses it to build the Glue record. The <code>ResultSet</code> object is implemented by each
         * driver, so the behavior is specific to the driver you use. Refer to the documentation for your JDBC driver to
         * understand how the driver performs the conversions.
         * </p>
         * 
         * @param dataTypeMapping
         *        Custom data type mapping that builds a mapping from a JDBC data type to an Glue data type. For
         *        example, the option <code>"dataTypeMapping":{"FLOAT":"STRING"}</code> maps data fields of JDBC type
         *        <code>FLOAT</code> into the Java <code>String</code> type by calling the
         *        <code>ResultSet.getString()</code> method of the driver, and uses it to build the Glue record. The
         *        <code>ResultSet</code> object is implemented by each driver, so the behavior is specific to the driver
         *        you use. Refer to the documentation for your JDBC driver to understand how the driver performs the
         *        conversions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTypeMappingWithStrings(Map<String, String> dataTypeMapping);

        /**
         * <p>
         * Custom data type mapping that builds a mapping from a JDBC data type to an Glue data type. For example, the
         * option <code>"dataTypeMapping":{"FLOAT":"STRING"}</code> maps data fields of JDBC type <code>FLOAT</code>
         * into the Java <code>String</code> type by calling the <code>ResultSet.getString()</code> method of the
         * driver, and uses it to build the Glue record. The <code>ResultSet</code> object is implemented by each
         * driver, so the behavior is specific to the driver you use. Refer to the documentation for your JDBC driver to
         * understand how the driver performs the conversions.
         * </p>
         * 
         * @param dataTypeMapping
         *        Custom data type mapping that builds a mapping from a JDBC data type to an Glue data type. For
         *        example, the option <code>"dataTypeMapping":{"FLOAT":"STRING"}</code> maps data fields of JDBC type
         *        <code>FLOAT</code> into the Java <code>String</code> type by calling the
         *        <code>ResultSet.getString()</code> method of the driver, and uses it to build the Glue record. The
         *        <code>ResultSet</code> object is implemented by each driver, so the behavior is specific to the driver
         *        you use. Refer to the documentation for your JDBC driver to understand how the driver performs the
         *        conversions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTypeMapping(Map<JDBCDataType, GlueRecordType> dataTypeMapping);
    }

    static final class BuilderImpl implements Builder {
        private String filterPredicate;

        private String partitionColumn;

        private Long lowerBound;

        private Long upperBound;

        private Long numPartitions;

        private List<String> jobBookmarkKeys = DefaultSdkAutoConstructList.getInstance();

        private String jobBookmarkKeysSortOrder;

        private Map<String, String> dataTypeMapping = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JDBCConnectorOptions model) {
            filterPredicate(model.filterPredicate);
            partitionColumn(model.partitionColumn);
            lowerBound(model.lowerBound);
            upperBound(model.upperBound);
            numPartitions(model.numPartitions);
            jobBookmarkKeys(model.jobBookmarkKeys);
            jobBookmarkKeysSortOrder(model.jobBookmarkKeysSortOrder);
            dataTypeMappingWithStrings(model.dataTypeMapping);
        }

        public final String getFilterPredicate() {
            return filterPredicate;
        }

        public final void setFilterPredicate(String filterPredicate) {
            this.filterPredicate = filterPredicate;
        }

        @Override
        public final Builder filterPredicate(String filterPredicate) {
            this.filterPredicate = filterPredicate;
            return this;
        }

        public final String getPartitionColumn() {
            return partitionColumn;
        }

        public final void setPartitionColumn(String partitionColumn) {
            this.partitionColumn = partitionColumn;
        }

        @Override
        public final Builder partitionColumn(String partitionColumn) {
            this.partitionColumn = partitionColumn;
            return this;
        }

        public final Long getLowerBound() {
            return lowerBound;
        }

        public final void setLowerBound(Long lowerBound) {
            this.lowerBound = lowerBound;
        }

        @Override
        public final Builder lowerBound(Long lowerBound) {
            this.lowerBound = lowerBound;
            return this;
        }

        public final Long getUpperBound() {
            return upperBound;
        }

        public final void setUpperBound(Long upperBound) {
            this.upperBound = upperBound;
        }

        @Override
        public final Builder upperBound(Long upperBound) {
            this.upperBound = upperBound;
            return this;
        }

        public final Long getNumPartitions() {
            return numPartitions;
        }

        public final void setNumPartitions(Long numPartitions) {
            this.numPartitions = numPartitions;
        }

        @Override
        public final Builder numPartitions(Long numPartitions) {
            this.numPartitions = numPartitions;
            return this;
        }

        public final Collection<String> getJobBookmarkKeys() {
            if (jobBookmarkKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return jobBookmarkKeys;
        }

        public final void setJobBookmarkKeys(Collection<String> jobBookmarkKeys) {
            this.jobBookmarkKeys = EnclosedInStringPropertiesCopier.copy(jobBookmarkKeys);
        }

        @Override
        public final Builder jobBookmarkKeys(Collection<String> jobBookmarkKeys) {
            this.jobBookmarkKeys = EnclosedInStringPropertiesCopier.copy(jobBookmarkKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobBookmarkKeys(String... jobBookmarkKeys) {
            jobBookmarkKeys(Arrays.asList(jobBookmarkKeys));
            return this;
        }

        public final String getJobBookmarkKeysSortOrder() {
            return jobBookmarkKeysSortOrder;
        }

        public final void setJobBookmarkKeysSortOrder(String jobBookmarkKeysSortOrder) {
            this.jobBookmarkKeysSortOrder = jobBookmarkKeysSortOrder;
        }

        @Override
        public final Builder jobBookmarkKeysSortOrder(String jobBookmarkKeysSortOrder) {
            this.jobBookmarkKeysSortOrder = jobBookmarkKeysSortOrder;
            return this;
        }

        public final Map<String, String> getDataTypeMapping() {
            if (dataTypeMapping instanceof SdkAutoConstructMap) {
                return null;
            }
            return dataTypeMapping;
        }

        public final void setDataTypeMapping(Map<String, String> dataTypeMapping) {
            this.dataTypeMapping = JDBCDataTypeMappingCopier.copy(dataTypeMapping);
        }

        @Override
        public final Builder dataTypeMappingWithStrings(Map<String, String> dataTypeMapping) {
            this.dataTypeMapping = JDBCDataTypeMappingCopier.copy(dataTypeMapping);
            return this;
        }

        @Override
        public final Builder dataTypeMapping(Map<JDBCDataType, GlueRecordType> dataTypeMapping) {
            this.dataTypeMapping = JDBCDataTypeMappingCopier.copyEnumToString(dataTypeMapping);
            return this;
        }

        @Override
        public JDBCConnectorOptions build() {
            return new JDBCConnectorOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
