/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents whether certain values are recognized as null values for removal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NullCheckBoxList implements SdkPojo, Serializable,
        ToCopyableBuilder<NullCheckBoxList.Builder, NullCheckBoxList> {
    private static final SdkField<Boolean> IS_EMPTY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsEmpty").getter(getter(NullCheckBoxList::isEmpty)).setter(setter(Builder::isEmpty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEmpty").build()).build();

    private static final SdkField<Boolean> IS_NULL_STRING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsNullString").getter(getter(NullCheckBoxList::isNullString)).setter(setter(Builder::isNullString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsNullString").build()).build();

    private static final SdkField<Boolean> IS_NEG_ONE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsNegOne").getter(getter(NullCheckBoxList::isNegOne)).setter(setter(Builder::isNegOne))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsNegOne").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_EMPTY_FIELD,
            IS_NULL_STRING_FIELD, IS_NEG_ONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean isEmpty;

    private final Boolean isNullString;

    private final Boolean isNegOne;

    private NullCheckBoxList(BuilderImpl builder) {
        this.isEmpty = builder.isEmpty;
        this.isNullString = builder.isNullString;
        this.isNegOne = builder.isNegOne;
    }

    /**
     * <p>
     * Specifies that an empty string is considered as a null value.
     * </p>
     * 
     * @return Specifies that an empty string is considered as a null value.
     */
    public final Boolean isEmpty() {
        return isEmpty;
    }

    /**
     * <p>
     * Specifies that a value spelling out the word 'null' is considered as a null value.
     * </p>
     * 
     * @return Specifies that a value spelling out the word 'null' is considered as a null value.
     */
    public final Boolean isNullString() {
        return isNullString;
    }

    /**
     * <p>
     * Specifies that an integer value of -1 is considered as a null value.
     * </p>
     * 
     * @return Specifies that an integer value of -1 is considered as a null value.
     */
    public final Boolean isNegOne() {
        return isNegOne;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isEmpty());
        hashCode = 31 * hashCode + Objects.hashCode(isNullString());
        hashCode = 31 * hashCode + Objects.hashCode(isNegOne());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NullCheckBoxList)) {
            return false;
        }
        NullCheckBoxList other = (NullCheckBoxList) obj;
        return Objects.equals(isEmpty(), other.isEmpty()) && Objects.equals(isNullString(), other.isNullString())
                && Objects.equals(isNegOne(), other.isNegOne());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NullCheckBoxList").add("IsEmpty", isEmpty()).add("IsNullString", isNullString())
                .add("IsNegOne", isNegOne()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IsEmpty":
            return Optional.ofNullable(clazz.cast(isEmpty()));
        case "IsNullString":
            return Optional.ofNullable(clazz.cast(isNullString()));
        case "IsNegOne":
            return Optional.ofNullable(clazz.cast(isNegOne()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NullCheckBoxList, T> g) {
        return obj -> g.apply((NullCheckBoxList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NullCheckBoxList> {
        /**
         * <p>
         * Specifies that an empty string is considered as a null value.
         * </p>
         * 
         * @param isEmpty
         *        Specifies that an empty string is considered as a null value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEmpty(Boolean isEmpty);

        /**
         * <p>
         * Specifies that a value spelling out the word 'null' is considered as a null value.
         * </p>
         * 
         * @param isNullString
         *        Specifies that a value spelling out the word 'null' is considered as a null value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNullString(Boolean isNullString);

        /**
         * <p>
         * Specifies that an integer value of -1 is considered as a null value.
         * </p>
         * 
         * @param isNegOne
         *        Specifies that an integer value of -1 is considered as a null value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNegOne(Boolean isNegOne);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isEmpty;

        private Boolean isNullString;

        private Boolean isNegOne;

        private BuilderImpl() {
        }

        private BuilderImpl(NullCheckBoxList model) {
            isEmpty(model.isEmpty);
            isNullString(model.isNullString);
            isNegOne(model.isNegOne);
        }

        public final Boolean getIsEmpty() {
            return isEmpty;
        }

        public final void setIsEmpty(Boolean isEmpty) {
            this.isEmpty = isEmpty;
        }

        @Override
        public final Builder isEmpty(Boolean isEmpty) {
            this.isEmpty = isEmpty;
            return this;
        }

        public final Boolean getIsNullString() {
            return isNullString;
        }

        public final void setIsNullString(Boolean isNullString) {
            this.isNullString = isNullString;
        }

        @Override
        public final Builder isNullString(Boolean isNullString) {
            this.isNullString = isNullString;
            return this;
        }

        public final Boolean getIsNegOne() {
            return isNegOne;
        }

        public final void setIsNegOne(Boolean isNegOne) {
            this.isNegOne = isNegOne;
        }

        @Override
        public final Builder isNegOne(Boolean isNegOne) {
            this.isNegOne = isNegOne;
            return this;
        }

        @Override
        public NullCheckBoxList build() {
            return new NullCheckBoxList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
