/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.ListSessionsRequest;
import software.amazon.awssdk.services.glue.model.ListSessionsResponse;

public class ListSessionsPublisher
implements SdkPublisher<ListSessionsResponse> {
    private final GlueAsyncClient client;
    private final ListSessionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSessionsPublisher(GlueAsyncClient client, ListSessionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSessionsPublisher(GlueAsyncClient client, ListSessionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSessionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSessionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSessionsResponseFetcher
    implements AsyncPageFetcher<ListSessionsResponse> {
        private ListSessionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSessionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSessionsResponse> nextPage(ListSessionsResponse previousPage) {
            if (previousPage == null) {
                return ListSessionsPublisher.this.client.listSessions(ListSessionsPublisher.this.firstRequest);
            }
            return ListSessionsPublisher.this.client.listSessions((ListSessionsRequest)((Object)ListSessionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

