/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMlLabelingSetGenerationTaskRunRequest extends GlueRequest implements
        ToCopyableBuilder<StartMlLabelingSetGenerationTaskRunRequest.Builder, StartMlLabelingSetGenerationTaskRunRequest> {
    private static final SdkField<String> TRANSFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformId").getter(getter(StartMlLabelingSetGenerationTaskRunRequest::transformId))
            .setter(setter(Builder::transformId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformId").build()).build();

    private static final SdkField<String> OUTPUT_S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputS3Path").getter(getter(StartMlLabelingSetGenerationTaskRunRequest::outputS3Path))
            .setter(setter(Builder::outputS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3Path").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_ID_FIELD,
            OUTPUT_S3_PATH_FIELD));

    private final String transformId;

    private final String outputS3Path;

    private StartMlLabelingSetGenerationTaskRunRequest(BuilderImpl builder) {
        super(builder);
        this.transformId = builder.transformId;
        this.outputS3Path = builder.outputS3Path;
    }

    /**
     * <p>
     * The unique identifier of the machine learning transform.
     * </p>
     * 
     * @return The unique identifier of the machine learning transform.
     */
    public String transformId() {
        return transformId;
    }

    /**
     * <p>
     * The Amazon Simple Storage Service (Amazon S3) path where you generate the labeling set.
     * </p>
     * 
     * @return The Amazon Simple Storage Service (Amazon S3) path where you generate the labeling set.
     */
    public String outputS3Path() {
        return outputS3Path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transformId());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Path());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMlLabelingSetGenerationTaskRunRequest)) {
            return false;
        }
        StartMlLabelingSetGenerationTaskRunRequest other = (StartMlLabelingSetGenerationTaskRunRequest) obj;
        return Objects.equals(transformId(), other.transformId()) && Objects.equals(outputS3Path(), other.outputS3Path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartMlLabelingSetGenerationTaskRunRequest").add("TransformId", transformId())
                .add("OutputS3Path", outputS3Path()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransformId":
            return Optional.ofNullable(clazz.cast(transformId()));
        case "OutputS3Path":
            return Optional.ofNullable(clazz.cast(outputS3Path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMlLabelingSetGenerationTaskRunRequest, T> g) {
        return obj -> g.apply((StartMlLabelingSetGenerationTaskRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMlLabelingSetGenerationTaskRunRequest> {
        /**
         * <p>
         * The unique identifier of the machine learning transform.
         * </p>
         * 
         * @param transformId
         *        The unique identifier of the machine learning transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformId(String transformId);

        /**
         * <p>
         * The Amazon Simple Storage Service (Amazon S3) path where you generate the labeling set.
         * </p>
         * 
         * @param outputS3Path
         *        The Amazon Simple Storage Service (Amazon S3) path where you generate the labeling set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Path(String outputS3Path);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String transformId;

        private String outputS3Path;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMlLabelingSetGenerationTaskRunRequest model) {
            super(model);
            transformId(model.transformId);
            outputS3Path(model.outputS3Path);
        }

        public final String getTransformId() {
            return transformId;
        }

        @Override
        public final Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public final void setTransformId(String transformId) {
            this.transformId = transformId;
        }

        public final String getOutputS3Path() {
            return outputS3Path;
        }

        @Override
        public final Builder outputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
            return this;
        }

        public final void setOutputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMlLabelingSetGenerationTaskRunRequest build() {
            return new StartMlLabelingSetGenerationTaskRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
