/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuerySchemaVersionMetadataResponse extends GlueResponse implements
        ToCopyableBuilder<QuerySchemaVersionMetadataResponse.Builder, QuerySchemaVersionMetadataResponse> {
    private static final SdkField<Map<String, MetadataInfo>> METADATA_INFO_MAP_FIELD = SdkField
            .<Map<String, MetadataInfo>> builder(MarshallingType.MAP)
            .memberName("MetadataInfoMap")
            .getter(getter(QuerySchemaVersionMetadataResponse::metadataInfoMap))
            .setter(setter(Builder::metadataInfoMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataInfoMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MetadataInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetadataInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersionId").getter(getter(QuerySchemaVersionMetadataResponse::schemaVersionId))
            .setter(setter(Builder::schemaVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(QuerySchemaVersionMetadataResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_INFO_MAP_FIELD,
            SCHEMA_VERSION_ID_FIELD, NEXT_TOKEN_FIELD));

    private final Map<String, MetadataInfo> metadataInfoMap;

    private final String schemaVersionId;

    private final String nextToken;

    private QuerySchemaVersionMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.metadataInfoMap = builder.metadataInfoMap;
        this.schemaVersionId = builder.schemaVersionId;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the MetadataInfoMap property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasMetadataInfoMap() {
        return metadataInfoMap != null && !(metadataInfoMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of a metadata key and associated values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetadataInfoMap()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of a metadata key and associated values.
     */
    public Map<String, MetadataInfo> metadataInfoMap() {
        return metadataInfoMap;
    }

    /**
     * <p>
     * The unique version ID of the schema version.
     * </p>
     * 
     * @return The unique version ID of the schema version.
     */
    public String schemaVersionId() {
        return schemaVersionId;
    }

    /**
     * <p>
     * A continuation token for paginating the returned list of tokens, returned if the current segment of the list is
     * not the last.
     * </p>
     * 
     * @return A continuation token for paginating the returned list of tokens, returned if the current segment of the
     *         list is not the last.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadataInfoMap() ? metadataInfoMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuerySchemaVersionMetadataResponse)) {
            return false;
        }
        QuerySchemaVersionMetadataResponse other = (QuerySchemaVersionMetadataResponse) obj;
        return hasMetadataInfoMap() == other.hasMetadataInfoMap() && Objects.equals(metadataInfoMap(), other.metadataInfoMap())
                && Objects.equals(schemaVersionId(), other.schemaVersionId()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QuerySchemaVersionMetadataResponse")
                .add("MetadataInfoMap", hasMetadataInfoMap() ? metadataInfoMap() : null)
                .add("SchemaVersionId", schemaVersionId()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetadataInfoMap":
            return Optional.ofNullable(clazz.cast(metadataInfoMap()));
        case "SchemaVersionId":
            return Optional.ofNullable(clazz.cast(schemaVersionId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuerySchemaVersionMetadataResponse, T> g) {
        return obj -> g.apply((QuerySchemaVersionMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, QuerySchemaVersionMetadataResponse> {
        /**
         * <p>
         * A map of a metadata key and associated values.
         * </p>
         * 
         * @param metadataInfoMap
         *        A map of a metadata key and associated values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataInfoMap(Map<String, MetadataInfo> metadataInfoMap);

        /**
         * <p>
         * The unique version ID of the schema version.
         * </p>
         * 
         * @param schemaVersionId
         *        The unique version ID of the schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersionId(String schemaVersionId);

        /**
         * <p>
         * A continuation token for paginating the returned list of tokens, returned if the current segment of the list
         * is not the last.
         * </p>
         * 
         * @param nextToken
         *        A continuation token for paginating the returned list of tokens, returned if the current segment of
         *        the list is not the last.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private Map<String, MetadataInfo> metadataInfoMap = DefaultSdkAutoConstructMap.getInstance();

        private String schemaVersionId;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(QuerySchemaVersionMetadataResponse model) {
            super(model);
            metadataInfoMap(model.metadataInfoMap);
            schemaVersionId(model.schemaVersionId);
            nextToken(model.nextToken);
        }

        public final Map<String, MetadataInfo.Builder> getMetadataInfoMap() {
            if (metadataInfoMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadataInfoMap != null ? CollectionUtils.mapValues(metadataInfoMap, MetadataInfo::toBuilder) : null;
        }

        @Override
        public final Builder metadataInfoMap(Map<String, MetadataInfo> metadataInfoMap) {
            this.metadataInfoMap = MetadataInfoMapCopier.copy(metadataInfoMap);
            return this;
        }

        public final void setMetadataInfoMap(Map<String, MetadataInfo.BuilderImpl> metadataInfoMap) {
            this.metadataInfoMap = MetadataInfoMapCopier.copyFromBuilder(metadataInfoMap);
        }

        public final String getSchemaVersionId() {
            return schemaVersionId;
        }

        @Override
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public QuerySchemaVersionMetadataResponse build() {
            return new QuerySchemaVersionMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
