/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResourcePolicyRequest extends GlueRequest implements
        ToCopyableBuilder<PutResourcePolicyRequest.Builder, PutResourcePolicyRequest> {
    private static final SdkField<String> POLICY_IN_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyInJson").getter(getter(PutResourcePolicyRequest::policyInJson))
            .setter(setter(Builder::policyInJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyInJson").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(PutResourcePolicyRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> POLICY_HASH_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyHashCondition").getter(getter(PutResourcePolicyRequest::policyHashCondition))
            .setter(setter(Builder::policyHashCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyHashCondition").build())
            .build();

    private static final SdkField<String> POLICY_EXISTS_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyExistsCondition").getter(getter(PutResourcePolicyRequest::policyExistsConditionAsString))
            .setter(setter(Builder::policyExistsCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyExistsCondition").build())
            .build();

    private static final SdkField<String> ENABLE_HYBRID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnableHybrid").getter(getter(PutResourcePolicyRequest::enableHybridAsString))
            .setter(setter(Builder::enableHybrid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableHybrid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_IN_JSON_FIELD,
            RESOURCE_ARN_FIELD, POLICY_HASH_CONDITION_FIELD, POLICY_EXISTS_CONDITION_FIELD, ENABLE_HYBRID_FIELD));

    private final String policyInJson;

    private final String resourceArn;

    private final String policyHashCondition;

    private final String policyExistsCondition;

    private final String enableHybrid;

    private PutResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyInJson = builder.policyInJson;
        this.resourceArn = builder.resourceArn;
        this.policyHashCondition = builder.policyHashCondition;
        this.policyExistsCondition = builder.policyExistsCondition;
        this.enableHybrid = builder.enableHybrid;
    }

    /**
     * <p>
     * Contains the policy document to set, in JSON format.
     * </p>
     * 
     * @return Contains the policy document to set, in JSON format.
     */
    public String policyInJson() {
        return policyInJson;
    }

    /**
     * <p>
     * The ARN of the AWS Glue resource for the resource policy to be set. For more information about AWS Glue resource
     * ARNs, see the <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id">AWS
     * Glue ARN string pattern</a>
     * </p>
     * 
     * @return The ARN of the AWS Glue resource for the resource policy to be set. For more information about AWS Glue
     *         resource ARNs, see the <a href=
     *         "https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id"
     *         >AWS Glue ARN string pattern</a>
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The hash value returned when the previous policy was set using <code>PutResourcePolicy</code>. Its purpose is to
     * prevent concurrent modifications of a policy. Do not use this parameter if no previous policy has been set.
     * </p>
     * 
     * @return The hash value returned when the previous policy was set using <code>PutResourcePolicy</code>. Its
     *         purpose is to prevent concurrent modifications of a policy. Do not use this parameter if no previous
     *         policy has been set.
     */
    public String policyHashCondition() {
        return policyHashCondition;
    }

    /**
     * <p>
     * A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is used to
     * create a new policy. If a value of <code>NONE</code> or a null value is used, the call will not depend on the
     * existence of a policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #policyExistsCondition} will return {@link ExistCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #policyExistsConditionAsString}.
     * </p>
     * 
     * @return A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is used
     *         to create a new policy. If a value of <code>NONE</code> or a null value is used, the call will not depend
     *         on the existence of a policy.
     * @see ExistCondition
     */
    public ExistCondition policyExistsCondition() {
        return ExistCondition.fromValue(policyExistsCondition);
    }

    /**
     * <p>
     * A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is used to
     * create a new policy. If a value of <code>NONE</code> or a null value is used, the call will not depend on the
     * existence of a policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #policyExistsCondition} will return {@link ExistCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #policyExistsConditionAsString}.
     * </p>
     * 
     * @return A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is used
     *         to create a new policy. If a value of <code>NONE</code> or a null value is used, the call will not depend
     *         on the existence of a policy.
     * @see ExistCondition
     */
    public String policyExistsConditionAsString() {
        return policyExistsCondition;
    }

    /**
     * <p>
     * Allows you to specify if you want to use both resource-level and account/catalog-level resource policies. A
     * resource-level policy is a policy attached to an individual resource such as a database or a table.
     * </p>
     * <p>
     * The default value of <code>NO</code> indicates that resource-level policies cannot co-exist with an account-level
     * policy. A value of <code>YES</code> means the use of both resource-level and account/catalog-level resource
     * policies is allowed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enableHybrid} will
     * return {@link EnableHybridValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #enableHybridAsString}.
     * </p>
     * 
     * @return Allows you to specify if you want to use both resource-level and account/catalog-level resource policies.
     *         A resource-level policy is a policy attached to an individual resource such as a database or a table.</p>
     *         <p>
     *         The default value of <code>NO</code> indicates that resource-level policies cannot co-exist with an
     *         account-level policy. A value of <code>YES</code> means the use of both resource-level and
     *         account/catalog-level resource policies is allowed.
     * @see EnableHybridValues
     */
    public EnableHybridValues enableHybrid() {
        return EnableHybridValues.fromValue(enableHybrid);
    }

    /**
     * <p>
     * Allows you to specify if you want to use both resource-level and account/catalog-level resource policies. A
     * resource-level policy is a policy attached to an individual resource such as a database or a table.
     * </p>
     * <p>
     * The default value of <code>NO</code> indicates that resource-level policies cannot co-exist with an account-level
     * policy. A value of <code>YES</code> means the use of both resource-level and account/catalog-level resource
     * policies is allowed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enableHybrid} will
     * return {@link EnableHybridValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #enableHybridAsString}.
     * </p>
     * 
     * @return Allows you to specify if you want to use both resource-level and account/catalog-level resource policies.
     *         A resource-level policy is a policy attached to an individual resource such as a database or a table.</p>
     *         <p>
     *         The default value of <code>NO</code> indicates that resource-level policies cannot co-exist with an
     *         account-level policy. A value of <code>YES</code> means the use of both resource-level and
     *         account/catalog-level resource policies is allowed.
     * @see EnableHybridValues
     */
    public String enableHybridAsString() {
        return enableHybrid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyInJson());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyHashCondition());
        hashCode = 31 * hashCode + Objects.hashCode(policyExistsConditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableHybridAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyRequest)) {
            return false;
        }
        PutResourcePolicyRequest other = (PutResourcePolicyRequest) obj;
        return Objects.equals(policyInJson(), other.policyInJson()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(policyHashCondition(), other.policyHashCondition())
                && Objects.equals(policyExistsConditionAsString(), other.policyExistsConditionAsString())
                && Objects.equals(enableHybridAsString(), other.enableHybridAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutResourcePolicyRequest").add("PolicyInJson", policyInJson()).add("ResourceArn", resourceArn())
                .add("PolicyHashCondition", policyHashCondition()).add("PolicyExistsCondition", policyExistsConditionAsString())
                .add("EnableHybrid", enableHybridAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyInJson":
            return Optional.ofNullable(clazz.cast(policyInJson()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "PolicyHashCondition":
            return Optional.ofNullable(clazz.cast(policyHashCondition()));
        case "PolicyExistsCondition":
            return Optional.ofNullable(clazz.cast(policyExistsConditionAsString()));
        case "EnableHybrid":
            return Optional.ofNullable(clazz.cast(enableHybridAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutResourcePolicyRequest, T> g) {
        return obj -> g.apply((PutResourcePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutResourcePolicyRequest> {
        /**
         * <p>
         * Contains the policy document to set, in JSON format.
         * </p>
         * 
         * @param policyInJson
         *        Contains the policy document to set, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyInJson(String policyInJson);

        /**
         * <p>
         * The ARN of the AWS Glue resource for the resource policy to be set. For more information about AWS Glue
         * resource ARNs, see the <a href=
         * "https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id">AWS
         * Glue ARN string pattern</a>
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the AWS Glue resource for the resource policy to be set. For more information about AWS
         *        Glue resource ARNs, see the <a href=
         *        "https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id"
         *        >AWS Glue ARN string pattern</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The hash value returned when the previous policy was set using <code>PutResourcePolicy</code>. Its purpose is
         * to prevent concurrent modifications of a policy. Do not use this parameter if no previous policy has been
         * set.
         * </p>
         * 
         * @param policyHashCondition
         *        The hash value returned when the previous policy was set using <code>PutResourcePolicy</code>. Its
         *        purpose is to prevent concurrent modifications of a policy. Do not use this parameter if no previous
         *        policy has been set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyHashCondition(String policyHashCondition);

        /**
         * <p>
         * A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is used to
         * create a new policy. If a value of <code>NONE</code> or a null value is used, the call will not depend on the
         * existence of a policy.
         * </p>
         * 
         * @param policyExistsCondition
         *        A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is
         *        used to create a new policy. If a value of <code>NONE</code> or a null value is used, the call will
         *        not depend on the existence of a policy.
         * @see ExistCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExistCondition
         */
        Builder policyExistsCondition(String policyExistsCondition);

        /**
         * <p>
         * A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is used to
         * create a new policy. If a value of <code>NONE</code> or a null value is used, the call will not depend on the
         * existence of a policy.
         * </p>
         * 
         * @param policyExistsCondition
         *        A value of <code>MUST_EXIST</code> is used to update a policy. A value of <code>NOT_EXIST</code> is
         *        used to create a new policy. If a value of <code>NONE</code> or a null value is used, the call will
         *        not depend on the existence of a policy.
         * @see ExistCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExistCondition
         */
        Builder policyExistsCondition(ExistCondition policyExistsCondition);

        /**
         * <p>
         * Allows you to specify if you want to use both resource-level and account/catalog-level resource policies. A
         * resource-level policy is a policy attached to an individual resource such as a database or a table.
         * </p>
         * <p>
         * The default value of <code>NO</code> indicates that resource-level policies cannot co-exist with an
         * account-level policy. A value of <code>YES</code> means the use of both resource-level and
         * account/catalog-level resource policies is allowed.
         * </p>
         * 
         * @param enableHybrid
         *        Allows you to specify if you want to use both resource-level and account/catalog-level resource
         *        policies. A resource-level policy is a policy attached to an individual resource such as a database or
         *        a table.</p>
         *        <p>
         *        The default value of <code>NO</code> indicates that resource-level policies cannot co-exist with an
         *        account-level policy. A value of <code>YES</code> means the use of both resource-level and
         *        account/catalog-level resource policies is allowed.
         * @see EnableHybridValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnableHybridValues
         */
        Builder enableHybrid(String enableHybrid);

        /**
         * <p>
         * Allows you to specify if you want to use both resource-level and account/catalog-level resource policies. A
         * resource-level policy is a policy attached to an individual resource such as a database or a table.
         * </p>
         * <p>
         * The default value of <code>NO</code> indicates that resource-level policies cannot co-exist with an
         * account-level policy. A value of <code>YES</code> means the use of both resource-level and
         * account/catalog-level resource policies is allowed.
         * </p>
         * 
         * @param enableHybrid
         *        Allows you to specify if you want to use both resource-level and account/catalog-level resource
         *        policies. A resource-level policy is a policy attached to an individual resource such as a database or
         *        a table.</p>
         *        <p>
         *        The default value of <code>NO</code> indicates that resource-level policies cannot co-exist with an
         *        account-level policy. A value of <code>YES</code> means the use of both resource-level and
         *        account/catalog-level resource policies is allowed.
         * @see EnableHybridValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnableHybridValues
         */
        Builder enableHybrid(EnableHybridValues enableHybrid);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String policyInJson;

        private String resourceArn;

        private String policyHashCondition;

        private String policyExistsCondition;

        private String enableHybrid;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyRequest model) {
            super(model);
            policyInJson(model.policyInJson);
            resourceArn(model.resourceArn);
            policyHashCondition(model.policyHashCondition);
            policyExistsCondition(model.policyExistsCondition);
            enableHybrid(model.enableHybrid);
        }

        public final String getPolicyInJson() {
            return policyInJson;
        }

        @Override
        public final Builder policyInJson(String policyInJson) {
            this.policyInJson = policyInJson;
            return this;
        }

        public final void setPolicyInJson(String policyInJson) {
            this.policyInJson = policyInJson;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getPolicyHashCondition() {
            return policyHashCondition;
        }

        @Override
        public final Builder policyHashCondition(String policyHashCondition) {
            this.policyHashCondition = policyHashCondition;
            return this;
        }

        public final void setPolicyHashCondition(String policyHashCondition) {
            this.policyHashCondition = policyHashCondition;
        }

        public final String getPolicyExistsCondition() {
            return policyExistsCondition;
        }

        @Override
        public final Builder policyExistsCondition(String policyExistsCondition) {
            this.policyExistsCondition = policyExistsCondition;
            return this;
        }

        @Override
        public final Builder policyExistsCondition(ExistCondition policyExistsCondition) {
            this.policyExistsCondition(policyExistsCondition == null ? null : policyExistsCondition.toString());
            return this;
        }

        public final void setPolicyExistsCondition(String policyExistsCondition) {
            this.policyExistsCondition = policyExistsCondition;
        }

        public final String getEnableHybrid() {
            return enableHybrid;
        }

        @Override
        public final Builder enableHybrid(String enableHybrid) {
            this.enableHybrid = enableHybrid;
            return this;
        }

        @Override
        public final Builder enableHybrid(EnableHybridValues enableHybrid) {
            this.enableHybrid(enableHybrid == null ? null : enableHybrid.toString());
            return this;
        }

        public final void setEnableHybrid(String enableHybrid) {
            this.enableHybrid = enableHybrid;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourcePolicyRequest build() {
            return new PutResourcePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
