/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A descriptor for a partition index in a table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartitionIndexDescriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<PartitionIndexDescriptor.Builder, PartitionIndexDescriptor> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(PartitionIndexDescriptor::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<List<KeySchemaElement>> KEYS_FIELD = SdkField
            .<List<KeySchemaElement>> builder(MarshallingType.LIST)
            .memberName("Keys")
            .getter(getter(PartitionIndexDescriptor::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeySchemaElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeySchemaElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexStatus").getter(getter(PartitionIndexDescriptor::indexStatusAsString))
            .setter(setter(Builder::indexStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD, KEYS_FIELD,
            INDEX_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String indexName;

    private final List<KeySchemaElement> keys;

    private final String indexStatus;

    private PartitionIndexDescriptor(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.keys = builder.keys;
        this.indexStatus = builder.indexStatus;
    }

    /**
     * <p>
     * The name of the partition index.
     * </p>
     * 
     * @return The name of the partition index.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * Returns true if the Keys property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.
     */
    public List<KeySchemaElement> keys() {
        return keys;
    }

    /**
     * <p>
     * The status of the partition index.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link PartitionIndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #indexStatusAsString}.
     * </p>
     * 
     * @return The status of the partition index.
     * @see PartitionIndexStatus
     */
    public PartitionIndexStatus indexStatus() {
        return PartitionIndexStatus.fromValue(indexStatus);
    }

    /**
     * <p>
     * The status of the partition index.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link PartitionIndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #indexStatusAsString}.
     * </p>
     * 
     * @return The status of the partition index.
     * @see PartitionIndexStatus
     */
    public String indexStatusAsString() {
        return indexStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(indexStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionIndexDescriptor)) {
            return false;
        }
        PartitionIndexDescriptor other = (PartitionIndexDescriptor) obj;
        return Objects.equals(indexName(), other.indexName()) && hasKeys() == other.hasKeys()
                && Objects.equals(keys(), other.keys()) && Objects.equals(indexStatusAsString(), other.indexStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PartitionIndexDescriptor").add("IndexName", indexName()).add("Keys", hasKeys() ? keys() : null)
                .add("IndexStatus", indexStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        case "IndexStatus":
            return Optional.ofNullable(clazz.cast(indexStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PartitionIndexDescriptor, T> g) {
        return obj -> g.apply((PartitionIndexDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartitionIndexDescriptor> {
        /**
         * <p>
         * The name of the partition index.
         * </p>
         * 
         * @param indexName
         *        The name of the partition index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.
         * </p>
         * 
         * @param keys
         *        A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Collection<KeySchemaElement> keys);

        /**
         * <p>
         * A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.
         * </p>
         * 
         * @param keys
         *        A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(KeySchemaElement... keys);

        /**
         * <p>
         * A list of one or more keys, as <code>KeySchemaElement</code> structures, for the partition index.
         * </p>
         * This is a convenience that creates an instance of the {@link List<KeySchemaElement>.Builder} avoiding the
         * need to create one manually via {@link List<KeySchemaElement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeySchemaElement>.Builder#build()} is called immediately and
         * its result is passed to {@link #keys(List<KeySchemaElement>)}.
         * 
         * @param keys
         *        a consumer that will call methods on {@link List<KeySchemaElement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keys(List<KeySchemaElement>)
         */
        Builder keys(Consumer<KeySchemaElement.Builder>... keys);

        /**
         * <p>
         * The status of the partition index.
         * </p>
         * 
         * @param indexStatus
         *        The status of the partition index.
         * @see PartitionIndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartitionIndexStatus
         */
        Builder indexStatus(String indexStatus);

        /**
         * <p>
         * The status of the partition index.
         * </p>
         * 
         * @param indexStatus
         *        The status of the partition index.
         * @see PartitionIndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartitionIndexStatus
         */
        Builder indexStatus(PartitionIndexStatus indexStatus);
    }

    static final class BuilderImpl implements Builder {
        private String indexName;

        private List<KeySchemaElement> keys = DefaultSdkAutoConstructList.getInstance();

        private String indexStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionIndexDescriptor model) {
            indexName(model.indexName);
            keys(model.keys);
            indexStatus(model.indexStatus);
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Collection<KeySchemaElement.Builder> getKeys() {
            if (keys instanceof SdkAutoConstructList) {
                return null;
            }
            return keys != null ? keys.stream().map(KeySchemaElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keys(Collection<KeySchemaElement> keys) {
            this.keys = KeySchemaElementListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(KeySchemaElement... keys) {
            keys(Arrays.asList(keys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(Consumer<KeySchemaElement.Builder>... keys) {
            keys(Stream.of(keys).map(c -> KeySchemaElement.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeys(Collection<KeySchemaElement.BuilderImpl> keys) {
            this.keys = KeySchemaElementListCopier.copyFromBuilder(keys);
        }

        public final String getIndexStatus() {
            return indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(PartitionIndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        public PartitionIndexDescriptor build() {
            return new PartitionIndexDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
