/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a Job node present in the workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobNodeDetails implements SdkPojo, Serializable, ToCopyableBuilder<JobNodeDetails.Builder, JobNodeDetails> {
    private static final SdkField<List<JobRun>> JOB_RUNS_FIELD = SdkField
            .<List<JobRun>> builder(MarshallingType.LIST)
            .memberName("JobRuns")
            .getter(getter(JobNodeDetails::jobRuns))
            .setter(setter(Builder::jobRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRuns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_RUNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<JobRun> jobRuns;

    private JobNodeDetails(BuilderImpl builder) {
        this.jobRuns = builder.jobRuns;
    }

    /**
     * Returns true if the JobRuns property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasJobRuns() {
        return jobRuns != null && !(jobRuns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information for the job runs represented by the job node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobRuns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The information for the job runs represented by the job node.
     */
    public List<JobRun> jobRuns() {
        return jobRuns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasJobRuns() ? jobRuns() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobNodeDetails)) {
            return false;
        }
        JobNodeDetails other = (JobNodeDetails) obj;
        return hasJobRuns() == other.hasJobRuns() && Objects.equals(jobRuns(), other.jobRuns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobNodeDetails").add("JobRuns", hasJobRuns() ? jobRuns() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobRuns":
            return Optional.ofNullable(clazz.cast(jobRuns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobNodeDetails, T> g) {
        return obj -> g.apply((JobNodeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobNodeDetails> {
        /**
         * <p>
         * The information for the job runs represented by the job node.
         * </p>
         * 
         * @param jobRuns
         *        The information for the job runs represented by the job node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRuns(Collection<JobRun> jobRuns);

        /**
         * <p>
         * The information for the job runs represented by the job node.
         * </p>
         * 
         * @param jobRuns
         *        The information for the job runs represented by the job node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRuns(JobRun... jobRuns);

        /**
         * <p>
         * The information for the job runs represented by the job node.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobRun>.Builder} avoiding the need to
         * create one manually via {@link List<JobRun>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobRun>.Builder#build()} is called immediately and its
         * result is passed to {@link #jobRuns(List<JobRun>)}.
         * 
         * @param jobRuns
         *        a consumer that will call methods on {@link List<JobRun>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobRuns(List<JobRun>)
         */
        Builder jobRuns(Consumer<JobRun.Builder>... jobRuns);
    }

    static final class BuilderImpl implements Builder {
        private List<JobRun> jobRuns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobNodeDetails model) {
            jobRuns(model.jobRuns);
        }

        public final Collection<JobRun.Builder> getJobRuns() {
            if (jobRuns instanceof SdkAutoConstructList) {
                return null;
            }
            return jobRuns != null ? jobRuns.stream().map(JobRun::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobRuns(Collection<JobRun> jobRuns) {
            this.jobRuns = JobRunListCopier.copy(jobRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRuns(JobRun... jobRuns) {
            jobRuns(Arrays.asList(jobRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRuns(Consumer<JobRun.Builder>... jobRuns) {
            jobRuns(Stream.of(jobRuns).map(c -> JobRun.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobRuns(Collection<JobRun.BuilderImpl> jobRuns) {
            this.jobRuns = JobRunListCopier.copyFromBuilder(jobRuns);
        }

        @Override
        public JobNodeDetails build() {
            return new JobNodeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
