/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMappingResponse extends GlueResponse implements
        ToCopyableBuilder<GetMappingResponse.Builder, GetMappingResponse> {
    private static final SdkField<List<MappingEntry>> MAPPING_FIELD = SdkField
            .<List<MappingEntry>> builder(MarshallingType.LIST)
            .memberName("Mapping")
            .getter(getter(GetMappingResponse::mapping))
            .setter(setter(Builder::mapping))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MappingEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(MappingEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAPPING_FIELD));

    private final List<MappingEntry> mapping;

    private GetMappingResponse(BuilderImpl builder) {
        super(builder);
        this.mapping = builder.mapping;
    }

    /**
     * Returns true if the Mapping property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMapping() {
        return mapping != null && !(mapping instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of mappings to the specified targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMapping()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of mappings to the specified targets.
     */
    public List<MappingEntry> mapping() {
        return mapping;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMapping() ? mapping() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMappingResponse)) {
            return false;
        }
        GetMappingResponse other = (GetMappingResponse) obj;
        return hasMapping() == other.hasMapping() && Objects.equals(mapping(), other.mapping());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMappingResponse").add("Mapping", hasMapping() ? mapping() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mapping":
            return Optional.ofNullable(clazz.cast(mapping()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMappingResponse, T> g) {
        return obj -> g.apply((GetMappingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMappingResponse> {
        /**
         * <p>
         * A list of mappings to the specified targets.
         * </p>
         * 
         * @param mapping
         *        A list of mappings to the specified targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapping(Collection<MappingEntry> mapping);

        /**
         * <p>
         * A list of mappings to the specified targets.
         * </p>
         * 
         * @param mapping
         *        A list of mappings to the specified targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapping(MappingEntry... mapping);

        /**
         * <p>
         * A list of mappings to the specified targets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MappingEntry>.Builder} avoiding the need to
         * create one manually via {@link List<MappingEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MappingEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #mapping(List<MappingEntry>)}.
         * 
         * @param mapping
         *        a consumer that will call methods on {@link List<MappingEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapping(List<MappingEntry>)
         */
        Builder mapping(Consumer<MappingEntry.Builder>... mapping);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<MappingEntry> mapping = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMappingResponse model) {
            super(model);
            mapping(model.mapping);
        }

        public final Collection<MappingEntry.Builder> getMapping() {
            if (mapping instanceof SdkAutoConstructList) {
                return null;
            }
            return mapping != null ? mapping.stream().map(MappingEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mapping(Collection<MappingEntry> mapping) {
            this.mapping = MappingListCopier.copy(mapping);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(MappingEntry... mapping) {
            mapping(Arrays.asList(mapping));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(Consumer<MappingEntry.Builder>... mapping) {
            mapping(Stream.of(mapping).map(c -> MappingEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMapping(Collection<MappingEntry.BuilderImpl> mapping) {
            this.mapping = MappingListCopier.copyFromBuilder(mapping);
        }

        @Override
        public GetMappingResponse build() {
            return new GetMappingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
