/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a condition under which a trigger fires.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Condition implements SdkPojo, Serializable, ToCopyableBuilder<Condition.Builder, Condition> {
    private static final SdkField<String> LOGICAL_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogicalOperator").getter(getter(Condition::logicalOperatorAsString))
            .setter(setter(Builder::logicalOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalOperator").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(Condition::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Condition::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> CRAWLER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CrawlerName").getter(getter(Condition::crawlerName)).setter(setter(Builder::crawlerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerName").build()).build();

    private static final SdkField<String> CRAWL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CrawlState").getter(getter(Condition::crawlStateAsString)).setter(setter(Builder::crawlState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_OPERATOR_FIELD,
            JOB_NAME_FIELD, STATE_FIELD, CRAWLER_NAME_FIELD, CRAWL_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logicalOperator;

    private final String jobName;

    private final String state;

    private final String crawlerName;

    private final String crawlState;

    private Condition(BuilderImpl builder) {
        this.logicalOperator = builder.logicalOperator;
        this.jobName = builder.jobName;
        this.state = builder.state;
        this.crawlerName = builder.crawlerName;
        this.crawlState = builder.crawlState;
    }

    /**
     * <p>
     * A logical operator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logicalOperator}
     * will return {@link LogicalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logicalOperatorAsString}.
     * </p>
     * 
     * @return A logical operator.
     * @see LogicalOperator
     */
    public LogicalOperator logicalOperator() {
        return LogicalOperator.fromValue(logicalOperator);
    }

    /**
     * <p>
     * A logical operator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logicalOperator}
     * will return {@link LogicalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logicalOperatorAsString}.
     * </p>
     * 
     * @return A logical operator.
     * @see LogicalOperator
     */
    public String logicalOperatorAsString() {
        return logicalOperator;
    }

    /**
     * <p>
     * The name of the job whose <code>JobRuns</code> this condition applies to, and on which this trigger waits.
     * </p>
     * 
     * @return The name of the job whose <code>JobRuns</code> this condition applies to, and on which this trigger
     *         waits.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The condition state. Currently, the only job states that a trigger can listen for are <code>SUCCEEDED</code>,
     * <code>STOPPED</code>, <code>FAILED</code>, and <code>TIMEOUT</code>. The only crawler states that a trigger can
     * listen for are <code>SUCCEEDED</code>, <code>FAILED</code>, and <code>CANCELLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JobRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The condition state. Currently, the only job states that a trigger can listen for are
     *         <code>SUCCEEDED</code>, <code>STOPPED</code>, <code>FAILED</code>, and <code>TIMEOUT</code>. The only
     *         crawler states that a trigger can listen for are <code>SUCCEEDED</code>, <code>FAILED</code>, and
     *         <code>CANCELLED</code>.
     * @see JobRunState
     */
    public JobRunState state() {
        return JobRunState.fromValue(state);
    }

    /**
     * <p>
     * The condition state. Currently, the only job states that a trigger can listen for are <code>SUCCEEDED</code>,
     * <code>STOPPED</code>, <code>FAILED</code>, and <code>TIMEOUT</code>. The only crawler states that a trigger can
     * listen for are <code>SUCCEEDED</code>, <code>FAILED</code>, and <code>CANCELLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JobRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The condition state. Currently, the only job states that a trigger can listen for are
     *         <code>SUCCEEDED</code>, <code>STOPPED</code>, <code>FAILED</code>, and <code>TIMEOUT</code>. The only
     *         crawler states that a trigger can listen for are <code>SUCCEEDED</code>, <code>FAILED</code>, and
     *         <code>CANCELLED</code>.
     * @see JobRunState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The name of the crawler to which this condition applies.
     * </p>
     * 
     * @return The name of the crawler to which this condition applies.
     */
    public String crawlerName() {
        return crawlerName;
    }

    /**
     * <p>
     * The state of the crawler to which this condition applies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #crawlState} will
     * return {@link CrawlState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #crawlStateAsString}.
     * </p>
     * 
     * @return The state of the crawler to which this condition applies.
     * @see CrawlState
     */
    public CrawlState crawlState() {
        return CrawlState.fromValue(crawlState);
    }

    /**
     * <p>
     * The state of the crawler to which this condition applies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #crawlState} will
     * return {@link CrawlState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #crawlStateAsString}.
     * </p>
     * 
     * @return The state of the crawler to which this condition applies.
     * @see CrawlState
     */
    public String crawlStateAsString() {
        return crawlState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logicalOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(crawlerName());
        hashCode = 31 * hashCode + Objects.hashCode(crawlStateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition) obj;
        return Objects.equals(logicalOperatorAsString(), other.logicalOperatorAsString())
                && Objects.equals(jobName(), other.jobName()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(crawlerName(), other.crawlerName())
                && Objects.equals(crawlStateAsString(), other.crawlStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Condition").add("LogicalOperator", logicalOperatorAsString()).add("JobName", jobName())
                .add("State", stateAsString()).add("CrawlerName", crawlerName()).add("CrawlState", crawlStateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogicalOperator":
            return Optional.ofNullable(clazz.cast(logicalOperatorAsString()));
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CrawlerName":
            return Optional.ofNullable(clazz.cast(crawlerName()));
        case "CrawlState":
            return Optional.ofNullable(clazz.cast(crawlStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Condition, T> g) {
        return obj -> g.apply((Condition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Condition> {
        /**
         * <p>
         * A logical operator.
         * </p>
         * 
         * @param logicalOperator
         *        A logical operator.
         * @see LogicalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogicalOperator
         */
        Builder logicalOperator(String logicalOperator);

        /**
         * <p>
         * A logical operator.
         * </p>
         * 
         * @param logicalOperator
         *        A logical operator.
         * @see LogicalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogicalOperator
         */
        Builder logicalOperator(LogicalOperator logicalOperator);

        /**
         * <p>
         * The name of the job whose <code>JobRuns</code> this condition applies to, and on which this trigger waits.
         * </p>
         * 
         * @param jobName
         *        The name of the job whose <code>JobRuns</code> this condition applies to, and on which this trigger
         *        waits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The condition state. Currently, the only job states that a trigger can listen for are <code>SUCCEEDED</code>,
         * <code>STOPPED</code>, <code>FAILED</code>, and <code>TIMEOUT</code>. The only crawler states that a trigger
         * can listen for are <code>SUCCEEDED</code>, <code>FAILED</code>, and <code>CANCELLED</code>.
         * </p>
         * 
         * @param state
         *        The condition state. Currently, the only job states that a trigger can listen for are
         *        <code>SUCCEEDED</code>, <code>STOPPED</code>, <code>FAILED</code>, and <code>TIMEOUT</code>. The only
         *        crawler states that a trigger can listen for are <code>SUCCEEDED</code>, <code>FAILED</code>, and
         *        <code>CANCELLED</code>.
         * @see JobRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunState
         */
        Builder state(String state);

        /**
         * <p>
         * The condition state. Currently, the only job states that a trigger can listen for are <code>SUCCEEDED</code>,
         * <code>STOPPED</code>, <code>FAILED</code>, and <code>TIMEOUT</code>. The only crawler states that a trigger
         * can listen for are <code>SUCCEEDED</code>, <code>FAILED</code>, and <code>CANCELLED</code>.
         * </p>
         * 
         * @param state
         *        The condition state. Currently, the only job states that a trigger can listen for are
         *        <code>SUCCEEDED</code>, <code>STOPPED</code>, <code>FAILED</code>, and <code>TIMEOUT</code>. The only
         *        crawler states that a trigger can listen for are <code>SUCCEEDED</code>, <code>FAILED</code>, and
         *        <code>CANCELLED</code>.
         * @see JobRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunState
         */
        Builder state(JobRunState state);

        /**
         * <p>
         * The name of the crawler to which this condition applies.
         * </p>
         * 
         * @param crawlerName
         *        The name of the crawler to which this condition applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerName(String crawlerName);

        /**
         * <p>
         * The state of the crawler to which this condition applies.
         * </p>
         * 
         * @param crawlState
         *        The state of the crawler to which this condition applies.
         * @see CrawlState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CrawlState
         */
        Builder crawlState(String crawlState);

        /**
         * <p>
         * The state of the crawler to which this condition applies.
         * </p>
         * 
         * @param crawlState
         *        The state of the crawler to which this condition applies.
         * @see CrawlState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CrawlState
         */
        Builder crawlState(CrawlState crawlState);
    }

    static final class BuilderImpl implements Builder {
        private String logicalOperator;

        private String jobName;

        private String state;

        private String crawlerName;

        private String crawlState;

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            logicalOperator(model.logicalOperator);
            jobName(model.jobName);
            state(model.state);
            crawlerName(model.crawlerName);
            crawlState(model.crawlState);
        }

        public final String getLogicalOperator() {
            return logicalOperator;
        }

        @Override
        public final Builder logicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
            return this;
        }

        @Override
        public final Builder logicalOperator(LogicalOperator logicalOperator) {
            this.logicalOperator(logicalOperator == null ? null : logicalOperator.toString());
            return this;
        }

        public final void setLogicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JobRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getCrawlerName() {
            return crawlerName;
        }

        @Override
        public final Builder crawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
            return this;
        }

        public final void setCrawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
        }

        public final String getCrawlState() {
            return crawlState;
        }

        @Override
        public final Builder crawlState(String crawlState) {
            this.crawlState = crawlState;
            return this;
        }

        @Override
        public final Builder crawlState(CrawlState crawlState) {
            this.crawlState(crawlState == null ? null : crawlState.toString());
            return this;
        }

        public final void setCrawlState(String crawlState) {
            this.crawlState = crawlState;
        }

        @Override
        public Condition build() {
            return new Condition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
