/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchStopJobRunRequest extends GlueRequest implements
        ToCopyableBuilder<BatchStopJobRunRequest.Builder, BatchStopJobRunRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(BatchStopJobRunRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<List<String>> JOB_RUN_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("JobRunIds")
            .getter(getter(BatchStopJobRunRequest::jobRunIds))
            .setter(setter(Builder::jobRunIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            JOB_RUN_IDS_FIELD));

    private final String jobName;

    private final List<String> jobRunIds;

    private BatchStopJobRunRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobRunIds = builder.jobRunIds;
    }

    /**
     * <p>
     * The name of the job definition for which to stop job runs.
     * </p>
     * 
     * @return The name of the job definition for which to stop job runs.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * Returns true if the JobRunIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasJobRunIds() {
        return jobRunIds != null && !(jobRunIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the <code>JobRunIds</code> that should be stopped for that job definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobRunIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the <code>JobRunIds</code> that should be stopped for that job definition.
     */
    public List<String> jobRunIds() {
        return jobRunIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(hasJobRunIds() ? jobRunIds() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStopJobRunRequest)) {
            return false;
        }
        BatchStopJobRunRequest other = (BatchStopJobRunRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && hasJobRunIds() == other.hasJobRunIds()
                && Objects.equals(jobRunIds(), other.jobRunIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchStopJobRunRequest").add("JobName", jobName())
                .add("JobRunIds", hasJobRunIds() ? jobRunIds() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobRunIds":
            return Optional.ofNullable(clazz.cast(jobRunIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchStopJobRunRequest, T> g) {
        return obj -> g.apply((BatchStopJobRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchStopJobRunRequest> {
        /**
         * <p>
         * The name of the job definition for which to stop job runs.
         * </p>
         * 
         * @param jobName
         *        The name of the job definition for which to stop job runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * A list of the <code>JobRunIds</code> that should be stopped for that job definition.
         * </p>
         * 
         * @param jobRunIds
         *        A list of the <code>JobRunIds</code> that should be stopped for that job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRunIds(Collection<String> jobRunIds);

        /**
         * <p>
         * A list of the <code>JobRunIds</code> that should be stopped for that job definition.
         * </p>
         * 
         * @param jobRunIds
         *        A list of the <code>JobRunIds</code> that should be stopped for that job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobRunIds(String... jobRunIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String jobName;

        private List<String> jobRunIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStopJobRunRequest model) {
            super(model);
            jobName(model.jobName);
            jobRunIds(model.jobRunIds);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final Collection<String> getJobRunIds() {
            if (jobRunIds instanceof SdkAutoConstructList) {
                return null;
            }
            return jobRunIds;
        }

        @Override
        public final Builder jobRunIds(Collection<String> jobRunIds) {
            this.jobRunIds = BatchStopJobRunJobRunIdListCopier.copy(jobRunIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobRunIds(String... jobRunIds) {
            jobRunIds(Arrays.asList(jobRunIds));
            return this;
        }

        public final void setJobRunIds(Collection<String> jobRunIds) {
            this.jobRunIds = BatchStopJobRunJobRunIdListCopier.copy(jobRunIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchStopJobRunRequest build() {
            return new BatchStopJobRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
