/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.glacier.DefaultGlacierAsyncClient;
import software.amazon.awssdk.services.glacier.DefaultGlacierBaseClientBuilder;
import software.amazon.awssdk.services.glacier.GlacierAsyncClient;
import software.amazon.awssdk.services.glacier.GlacierAsyncClientBuilder;
import software.amazon.awssdk.services.glacier.GlacierServiceClientConfiguration;
import software.amazon.awssdk.services.glacier.endpoints.GlacierEndpointProvider;

@SdkInternalApi
final class DefaultGlacierAsyncClientBuilder
extends DefaultGlacierBaseClientBuilder<GlacierAsyncClientBuilder, GlacierAsyncClient>
implements GlacierAsyncClientBuilder {
    DefaultGlacierAsyncClientBuilder() {
    }

    @Override
    public DefaultGlacierAsyncClientBuilder endpointProvider(GlacierEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GlacierAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultGlacierAsyncClientBuilder.validateClientOptions(clientConfiguration);
        GlacierServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultGlacierAsyncClient client = new DefaultGlacierAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private GlacierServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return GlacierServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

