/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration section.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Section implements SdkPojo, Serializable, ToCopyableBuilder<Section.Builder, Section> {
    private static final SdkField<Document> ATTRIBUTES_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("Attributes").getter(getter(Section::attributes)).setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Section::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Size")
            .getter(getter(Section::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD, NAME_FIELD,
            SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Document attributes;

    private final String name;

    private final Integer size;

    private Section(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.name = builder.name;
        this.size = builder.size;
    }

    /**
     * <p>
     * The content of a configuration section.
     * </p>
     * 
     * @return The content of a configuration section.
     */
    public final Document attributes() {
        return attributes;
    }

    /**
     * <p>
     * The name of the section.
     * </p>
     * 
     * @return The name of the section.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The size, in bytes, of the section contents.
     * </p>
     * 
     * @return The size, in bytes, of the section contents.
     */
    public final Integer size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Section)) {
            return false;
        }
        Section other = (Section) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(name(), other.name())
                && Objects.equals(size(), other.size());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Section").add("Attributes", attributes()).add("Name", name()).add("Size", size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Section, T> g) {
        return obj -> g.apply((Section) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Section> {
        /**
         * <p>
         * The content of a configuration section.
         * </p>
         * 
         * @param attributes
         *        The content of a configuration section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Document attributes);

        /**
         * <p>
         * The name of the section.
         * </p>
         * 
         * @param name
         *        The name of the section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The size, in bytes, of the section contents.
         * </p>
         * 
         * @param size
         *        The size, in bytes, of the section contents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);
    }

    static final class BuilderImpl implements Builder {
        private Document attributes;

        private String name;

        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(Section model) {
            attributes(model.attributes);
            name(model.name);
            size(model.size);
        }

        public final Document getAttributes() {
            return attributes;
        }

        public final void setAttributes(Document attributes) {
            this.attributes = attributes;
        }

        @Override
        public final Builder attributes(Document attributes) {
            this.attributes = attributes;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        @Override
        public Section build() {
            return new Section(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
