/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties that specify the code generator for a generated code job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Generator implements SdkPojo, Serializable, ToCopyableBuilder<Generator.Builder, Generator> {
    private static final SdkField<String> GAME_SDK_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameSdkVersion").getter(getter(Generator::gameSdkVersion)).setter(setter(Builder::gameSdkVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSdkVersion").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Language").getter(getter(Generator::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<String> TARGET_PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetPlatform").getter(getter(Generator::targetPlatform)).setter(setter(Builder::targetPlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPlatform").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SDK_VERSION_FIELD,
            LANGUAGE_FIELD, TARGET_PLATFORM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String gameSdkVersion;

    private final String language;

    private final String targetPlatform;

    private Generator(BuilderImpl builder) {
        this.gameSdkVersion = builder.gameSdkVersion;
        this.language = builder.language;
        this.targetPlatform = builder.targetPlatform;
    }

    /**
     * <p>
     * The target version of the GameSparks Game SDK.
     * </p>
     * 
     * @return The target version of the GameSparks Game SDK.
     */
    public final String gameSdkVersion() {
        return gameSdkVersion;
    }

    /**
     * <p>
     * The programming language for the generated code.
     * </p>
     * <p>
     * Not all languages are supported for each platform. For cases where multiple languages are supported, this
     * parameter specifies the language to be used. If this value is omitted, the default language for the target
     * platform will be used.
     * </p>
     * 
     * @return The programming language for the generated code.</p>
     *         <p>
     *         Not all languages are supported for each platform. For cases where multiple languages are supported, this
     *         parameter specifies the language to be used. If this value is omitted, the default language for the
     *         target platform will be used.
     */
    public final String language() {
        return language;
    }

    /**
     * <p>
     * The platform that will be used to run the generated code.
     * </p>
     * 
     * @return The platform that will be used to run the generated code.
     */
    public final String targetPlatform() {
        return targetPlatform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gameSdkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(targetPlatform());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Generator)) {
            return false;
        }
        Generator other = (Generator) obj;
        return Objects.equals(gameSdkVersion(), other.gameSdkVersion()) && Objects.equals(language(), other.language())
                && Objects.equals(targetPlatform(), other.targetPlatform());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Generator").add("GameSdkVersion", gameSdkVersion()).add("Language", language())
                .add("TargetPlatform", targetPlatform()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameSdkVersion":
            return Optional.ofNullable(clazz.cast(gameSdkVersion()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "TargetPlatform":
            return Optional.ofNullable(clazz.cast(targetPlatform()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Generator, T> g) {
        return obj -> g.apply((Generator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Generator> {
        /**
         * <p>
         * The target version of the GameSparks Game SDK.
         * </p>
         * 
         * @param gameSdkVersion
         *        The target version of the GameSparks Game SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSdkVersion(String gameSdkVersion);

        /**
         * <p>
         * The programming language for the generated code.
         * </p>
         * <p>
         * Not all languages are supported for each platform. For cases where multiple languages are supported, this
         * parameter specifies the language to be used. If this value is omitted, the default language for the target
         * platform will be used.
         * </p>
         * 
         * @param language
         *        The programming language for the generated code.</p>
         *        <p>
         *        Not all languages are supported for each platform. For cases where multiple languages are supported,
         *        this parameter specifies the language to be used. If this value is omitted, the default language for
         *        the target platform will be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * The platform that will be used to run the generated code.
         * </p>
         * 
         * @param targetPlatform
         *        The platform that will be used to run the generated code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPlatform(String targetPlatform);
    }

    static final class BuilderImpl implements Builder {
        private String gameSdkVersion;

        private String language;

        private String targetPlatform;

        private BuilderImpl() {
        }

        private BuilderImpl(Generator model) {
            gameSdkVersion(model.gameSdkVersion);
            language(model.language);
            targetPlatform(model.targetPlatform);
        }

        public final String getGameSdkVersion() {
            return gameSdkVersion;
        }

        public final void setGameSdkVersion(String gameSdkVersion) {
            this.gameSdkVersion = gameSdkVersion;
        }

        @Override
        public final Builder gameSdkVersion(String gameSdkVersion) {
            this.gameSdkVersion = gameSdkVersion;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getTargetPlatform() {
            return targetPlatform;
        }

        public final void setTargetPlatform(String targetPlatform) {
            this.targetPlatform = targetPlatform;
        }

        @Override
        public final Builder targetPlatform(String targetPlatform) {
            this.targetPlatform = targetPlatform;
            return this;
        }

        @Override
        public Generator build() {
            return new Generator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
