/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExtensionVersionsResponse extends GameSparksResponse implements
        ToCopyableBuilder<ListExtensionVersionsResponse.Builder, ListExtensionVersionsResponse> {
    private static final SdkField<List<ExtensionVersionDetails>> EXTENSION_VERSIONS_FIELD = SdkField
            .<List<ExtensionVersionDetails>> builder(MarshallingType.LIST)
            .memberName("ExtensionVersions")
            .getter(getter(ListExtensionVersionsResponse::extensionVersions))
            .setter(setter(Builder::extensionVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExtensionVersionDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExtensionVersionDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListExtensionVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENSION_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ExtensionVersionDetails> extensionVersions;

    private final String nextToken;

    private ListExtensionVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.extensionVersions = builder.extensionVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExtensionVersions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExtensionVersions() {
        return extensionVersions != null && !(extensionVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of extension versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExtensionVersions} method.
     * </p>
     * 
     * @return The list of extension versions.
     */
    public final List<ExtensionVersionDetails> extensionVersions() {
        return extensionVersions;
    }

    /**
     * <p>
     * The token that indicates the start of the next sequential page of results.
     * </p>
     * <p>
     * Use this value when making the next call to this operation to continue where the last one finished.
     * </p>
     * 
     * @return The token that indicates the start of the next sequential page of results.</p>
     *         <p>
     *         Use this value when making the next call to this operation to continue where the last one finished.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExtensionVersions() ? extensionVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExtensionVersionsResponse)) {
            return false;
        }
        ListExtensionVersionsResponse other = (ListExtensionVersionsResponse) obj;
        return hasExtensionVersions() == other.hasExtensionVersions()
                && Objects.equals(extensionVersions(), other.extensionVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListExtensionVersionsResponse")
                .add("ExtensionVersions", hasExtensionVersions() ? extensionVersions() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExtensionVersions":
            return Optional.ofNullable(clazz.cast(extensionVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExtensionVersionsResponse, T> g) {
        return obj -> g.apply((ListExtensionVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListExtensionVersionsResponse> {
        /**
         * <p>
         * The list of extension versions.
         * </p>
         * 
         * @param extensionVersions
         *        The list of extension versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionVersions(Collection<ExtensionVersionDetails> extensionVersions);

        /**
         * <p>
         * The list of extension versions.
         * </p>
         * 
         * @param extensionVersions
         *        The list of extension versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionVersions(ExtensionVersionDetails... extensionVersions);

        /**
         * <p>
         * The list of extension versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamesparks.model.ExtensionVersionDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.gamesparks.model.ExtensionVersionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamesparks.model.ExtensionVersionDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #extensionVersions(List<ExtensionVersionDetails>)}.
         * 
         * @param extensionVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamesparks.model.ExtensionVersionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #extensionVersions(java.util.Collection<ExtensionVersionDetails>)
         */
        Builder extensionVersions(Consumer<ExtensionVersionDetails.Builder>... extensionVersions);

        /**
         * <p>
         * The token that indicates the start of the next sequential page of results.
         * </p>
         * <p>
         * Use this value when making the next call to this operation to continue where the last one finished.
         * </p>
         * 
         * @param nextToken
         *        The token that indicates the start of the next sequential page of results.</p>
         *        <p>
         *        Use this value when making the next call to this operation to continue where the last one finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameSparksResponse.BuilderImpl implements Builder {
        private List<ExtensionVersionDetails> extensionVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExtensionVersionsResponse model) {
            super(model);
            extensionVersions(model.extensionVersions);
            nextToken(model.nextToken);
        }

        public final List<ExtensionVersionDetails.Builder> getExtensionVersions() {
            List<ExtensionVersionDetails.Builder> result = ExtensionVersionDetailsListCopier
                    .copyToBuilder(this.extensionVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExtensionVersions(Collection<ExtensionVersionDetails.BuilderImpl> extensionVersions) {
            this.extensionVersions = ExtensionVersionDetailsListCopier.copyFromBuilder(extensionVersions);
        }

        @Override
        public final Builder extensionVersions(Collection<ExtensionVersionDetails> extensionVersions) {
            this.extensionVersions = ExtensionVersionDetailsListCopier.copy(extensionVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensionVersions(ExtensionVersionDetails... extensionVersions) {
            extensionVersions(Arrays.asList(extensionVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensionVersions(Consumer<ExtensionVersionDetails.Builder>... extensionVersions) {
            extensionVersions(Stream.of(extensionVersions).map(c -> ExtensionVersionDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListExtensionVersionsResponse build() {
            return new ListExtensionVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
