/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a generated code job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeneratedCodeJobDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<GeneratedCodeJobDetails.Builder, GeneratedCodeJobDetails> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GeneratedCodeJobDetails::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationTime")
            .getter(getter(GeneratedCodeJobDetails::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> GENERATED_CODE_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeneratedCodeJobId").getter(getter(GeneratedCodeJobDetails::generatedCodeJobId))
            .setter(setter(Builder::generatedCodeJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedCodeJobId").build())
            .build();

    private static final SdkField<String> S3_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Url")
            .getter(getter(GeneratedCodeJobDetails::s3Url)).setter(setter(Builder::s3Url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Url").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GeneratedCodeJobDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            EXPIRATION_TIME_FIELD, GENERATED_CODE_JOB_ID_FIELD, S3_URL_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final Instant expirationTime;

    private final String generatedCodeJobId;

    private final String s3Url;

    private final String status;

    private GeneratedCodeJobDetails(BuilderImpl builder) {
        this.description = builder.description;
        this.expirationTime = builder.expirationTime;
        this.generatedCodeJobId = builder.generatedCodeJobId;
        this.s3Url = builder.s3Url;
        this.status = builder.status;
    }

    /**
     * <p>
     * The description of the generated code job.
     * </p>
     * 
     * @return The description of the generated code job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The expiration date and time for the download URL.
     * </p>
     * <p>
     * The download URL us guaranteed to be available until at least this time.
     * </p>
     * 
     * @return The expiration date and time for the download URL.</p>
     *         <p>
     *         The download URL us guaranteed to be available until at least this time.
     */
    public final Instant expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * The identifier for the generated code job.
     * </p>
     * 
     * @return The identifier for the generated code job.
     */
    public final String generatedCodeJobId() {
        return generatedCodeJobId;
    }

    /**
     * <p>
     * A presigned URL that can be used to download the generated code.
     * </p>
     * 
     * @return A presigned URL that can be used to download the generated code.
     */
    public final String s3Url() {
        return s3Url;
    }

    /**
     * <p>
     * The status of the generated code job
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GeneratedCodeJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the generated code job
     * @see GeneratedCodeJobState
     */
    public final GeneratedCodeJobState status() {
        return GeneratedCodeJobState.fromValue(status);
    }

    /**
     * <p>
     * The status of the generated code job
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GeneratedCodeJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the generated code job
     * @see GeneratedCodeJobState
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(generatedCodeJobId());
        hashCode = 31 * hashCode + Objects.hashCode(s3Url());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratedCodeJobDetails)) {
            return false;
        }
        GeneratedCodeJobDetails other = (GeneratedCodeJobDetails) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(expirationTime(), other.expirationTime())
                && Objects.equals(generatedCodeJobId(), other.generatedCodeJobId()) && Objects.equals(s3Url(), other.s3Url())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeneratedCodeJobDetails").add("Description", description())
                .add("ExpirationTime", expirationTime()).add("GeneratedCodeJobId", generatedCodeJobId()).add("S3Url", s3Url())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ExpirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "GeneratedCodeJobId":
            return Optional.ofNullable(clazz.cast(generatedCodeJobId()));
        case "S3Url":
            return Optional.ofNullable(clazz.cast(s3Url()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeneratedCodeJobDetails, T> g) {
        return obj -> g.apply((GeneratedCodeJobDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeneratedCodeJobDetails> {
        /**
         * <p>
         * The description of the generated code job.
         * </p>
         * 
         * @param description
         *        The description of the generated code job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The expiration date and time for the download URL.
         * </p>
         * <p>
         * The download URL us guaranteed to be available until at least this time.
         * </p>
         * 
         * @param expirationTime
         *        The expiration date and time for the download URL.</p>
         *        <p>
         *        The download URL us guaranteed to be available until at least this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * <p>
         * The identifier for the generated code job.
         * </p>
         * 
         * @param generatedCodeJobId
         *        The identifier for the generated code job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedCodeJobId(String generatedCodeJobId);

        /**
         * <p>
         * A presigned URL that can be used to download the generated code.
         * </p>
         * 
         * @param s3Url
         *        A presigned URL that can be used to download the generated code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Url(String s3Url);

        /**
         * <p>
         * The status of the generated code job
         * </p>
         * 
         * @param status
         *        The status of the generated code job
         * @see GeneratedCodeJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedCodeJobState
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the generated code job
         * </p>
         * 
         * @param status
         *        The status of the generated code job
         * @see GeneratedCodeJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeneratedCodeJobState
         */
        Builder status(GeneratedCodeJobState status);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private Instant expirationTime;

        private String generatedCodeJobId;

        private String s3Url;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratedCodeJobDetails model) {
            description(model.description);
            expirationTime(model.expirationTime);
            generatedCodeJobId(model.generatedCodeJobId);
            s3Url(model.s3Url);
            status(model.status);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final String getGeneratedCodeJobId() {
            return generatedCodeJobId;
        }

        public final void setGeneratedCodeJobId(String generatedCodeJobId) {
            this.generatedCodeJobId = generatedCodeJobId;
        }

        @Override
        public final Builder generatedCodeJobId(String generatedCodeJobId) {
            this.generatedCodeJobId = generatedCodeJobId;
            return this;
        }

        public final String getS3Url() {
            return s3Url;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GeneratedCodeJobState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GeneratedCodeJobDetails build() {
            return new GeneratedCodeJobDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
