/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisconnectPlayerRequest extends GameSparksRequest implements
        ToCopyableBuilder<DisconnectPlayerRequest.Builder, DisconnectPlayerRequest> {
    private static final SdkField<String> GAME_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameName").getter(getter(DisconnectPlayerRequest::gameName)).setter(setter(Builder::gameName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("GameName").build()).build();

    private static final SdkField<String> PLAYER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlayerId").getter(getter(DisconnectPlayerRequest::playerId)).setter(setter(Builder::playerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PlayerId").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageName").getter(getter(DisconnectPlayerRequest::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("StageName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_NAME_FIELD,
            PLAYER_ID_FIELD, STAGE_NAME_FIELD));

    private final String gameName;

    private final String playerId;

    private final String stageName;

    private DisconnectPlayerRequest(BuilderImpl builder) {
        super(builder);
        this.gameName = builder.gameName;
        this.playerId = builder.playerId;
        this.stageName = builder.stageName;
    }

    /**
     * <p>
     * The name of the game.
     * </p>
     * 
     * @return The name of the game.
     */
    public final String gameName() {
        return gameName;
    }

    /**
     * <p>
     * The unique identifier representing a player.
     * </p>
     * 
     * @return The unique identifier representing a player.
     */
    public final String playerId() {
        return playerId;
    }

    /**
     * <p>
     * The name of the stage.
     * </p>
     * 
     * @return The name of the stage.
     */
    public final String stageName() {
        return stageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameName());
        hashCode = 31 * hashCode + Objects.hashCode(playerId());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisconnectPlayerRequest)) {
            return false;
        }
        DisconnectPlayerRequest other = (DisconnectPlayerRequest) obj;
        return Objects.equals(gameName(), other.gameName()) && Objects.equals(playerId(), other.playerId())
                && Objects.equals(stageName(), other.stageName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisconnectPlayerRequest").add("GameName", gameName()).add("PlayerId", playerId())
                .add("StageName", stageName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameName":
            return Optional.ofNullable(clazz.cast(gameName()));
        case "PlayerId":
            return Optional.ofNullable(clazz.cast(playerId()));
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisconnectPlayerRequest, T> g) {
        return obj -> g.apply((DisconnectPlayerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DisconnectPlayerRequest> {
        /**
         * <p>
         * The name of the game.
         * </p>
         * 
         * @param gameName
         *        The name of the game.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameName(String gameName);

        /**
         * <p>
         * The unique identifier representing a player.
         * </p>
         * 
         * @param playerId
         *        The unique identifier representing a player.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerId(String playerId);

        /**
         * <p>
         * The name of the stage.
         * </p>
         * 
         * @param stageName
         *        The name of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameSparksRequest.BuilderImpl implements Builder {
        private String gameName;

        private String playerId;

        private String stageName;

        private BuilderImpl() {
        }

        private BuilderImpl(DisconnectPlayerRequest model) {
            super(model);
            gameName(model.gameName);
            playerId(model.playerId);
            stageName(model.stageName);
        }

        public final String getGameName() {
            return gameName;
        }

        public final void setGameName(String gameName) {
            this.gameName = gameName;
        }

        @Override
        public final Builder gameName(String gameName) {
            this.gameName = gameName;
            return this;
        }

        public final String getPlayerId() {
            return playerId;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisconnectPlayerRequest build() {
            return new DisconnectPlayerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
