/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGeneratedCodeJobsResponse extends GameSparksResponse implements
        ToCopyableBuilder<ListGeneratedCodeJobsResponse.Builder, ListGeneratedCodeJobsResponse> {
    private static final SdkField<List<GeneratedCodeJobDetails>> GENERATED_CODE_JOBS_FIELD = SdkField
            .<List<GeneratedCodeJobDetails>> builder(MarshallingType.LIST)
            .memberName("GeneratedCodeJobs")
            .getter(getter(ListGeneratedCodeJobsResponse::generatedCodeJobs))
            .setter(setter(Builder::generatedCodeJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedCodeJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GeneratedCodeJobDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(GeneratedCodeJobDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListGeneratedCodeJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_CODE_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<GeneratedCodeJobDetails> generatedCodeJobs;

    private final String nextToken;

    private ListGeneratedCodeJobsResponse(BuilderImpl builder) {
        super(builder);
        this.generatedCodeJobs = builder.generatedCodeJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the GeneratedCodeJobs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGeneratedCodeJobs() {
        return generatedCodeJobs != null && !(generatedCodeJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of generated code jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGeneratedCodeJobs} method.
     * </p>
     * 
     * @return The list of generated code jobs.
     */
    public final List<GeneratedCodeJobDetails> generatedCodeJobs() {
        return generatedCodeJobs;
    }

    /**
     * <p>
     * The token that indicates the start of the next sequential page of results.
     * </p>
     * <p>
     * Use this value when making the next call to this operation to continue where the last one finished.
     * </p>
     * 
     * @return The token that indicates the start of the next sequential page of results.</p>
     *         <p>
     *         Use this value when making the next call to this operation to continue where the last one finished.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGeneratedCodeJobs() ? generatedCodeJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeneratedCodeJobsResponse)) {
            return false;
        }
        ListGeneratedCodeJobsResponse other = (ListGeneratedCodeJobsResponse) obj;
        return hasGeneratedCodeJobs() == other.hasGeneratedCodeJobs()
                && Objects.equals(generatedCodeJobs(), other.generatedCodeJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGeneratedCodeJobsResponse")
                .add("GeneratedCodeJobs", hasGeneratedCodeJobs() ? generatedCodeJobs() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeneratedCodeJobs":
            return Optional.ofNullable(clazz.cast(generatedCodeJobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGeneratedCodeJobsResponse, T> g) {
        return obj -> g.apply((ListGeneratedCodeJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameSparksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListGeneratedCodeJobsResponse> {
        /**
         * <p>
         * The list of generated code jobs.
         * </p>
         * 
         * @param generatedCodeJobs
         *        The list of generated code jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedCodeJobs(Collection<GeneratedCodeJobDetails> generatedCodeJobs);

        /**
         * <p>
         * The list of generated code jobs.
         * </p>
         * 
         * @param generatedCodeJobs
         *        The list of generated code jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedCodeJobs(GeneratedCodeJobDetails... generatedCodeJobs);

        /**
         * <p>
         * The list of generated code jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamesparks.model.GeneratedCodeJobDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.gamesparks.model.GeneratedCodeJobDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamesparks.model.GeneratedCodeJobDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #generatedCodeJobs(List<GeneratedCodeJobDetails>)}.
         * 
         * @param generatedCodeJobs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamesparks.model.GeneratedCodeJobDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generatedCodeJobs(java.util.Collection<GeneratedCodeJobDetails>)
         */
        Builder generatedCodeJobs(Consumer<GeneratedCodeJobDetails.Builder>... generatedCodeJobs);

        /**
         * <p>
         * The token that indicates the start of the next sequential page of results.
         * </p>
         * <p>
         * Use this value when making the next call to this operation to continue where the last one finished.
         * </p>
         * 
         * @param nextToken
         *        The token that indicates the start of the next sequential page of results.</p>
         *        <p>
         *        Use this value when making the next call to this operation to continue where the last one finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GameSparksResponse.BuilderImpl implements Builder {
        private List<GeneratedCodeJobDetails> generatedCodeJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeneratedCodeJobsResponse model) {
            super(model);
            generatedCodeJobs(model.generatedCodeJobs);
            nextToken(model.nextToken);
        }

        public final List<GeneratedCodeJobDetails.Builder> getGeneratedCodeJobs() {
            List<GeneratedCodeJobDetails.Builder> result = GeneratedCodeJobDetailsListCopier
                    .copyToBuilder(this.generatedCodeJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeneratedCodeJobs(Collection<GeneratedCodeJobDetails.BuilderImpl> generatedCodeJobs) {
            this.generatedCodeJobs = GeneratedCodeJobDetailsListCopier.copyFromBuilder(generatedCodeJobs);
        }

        @Override
        public final Builder generatedCodeJobs(Collection<GeneratedCodeJobDetails> generatedCodeJobs) {
            this.generatedCodeJobs = GeneratedCodeJobDetailsListCopier.copy(generatedCodeJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedCodeJobs(GeneratedCodeJobDetails... generatedCodeJobs) {
            generatedCodeJobs(Arrays.asList(generatedCodeJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder generatedCodeJobs(Consumer<GeneratedCodeJobDetails.Builder>... generatedCodeJobs) {
            generatedCodeJobs(Stream.of(generatedCodeJobs).map(c -> GeneratedCodeJobDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGeneratedCodeJobsResponse build() {
            return new ListGeneratedCodeJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
