/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GameServerInstanceStatus {
    ACTIVE("ACTIVE"),
    DRAINING("DRAINING"),
    SPOT_TERMINATING("SPOT_TERMINATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GameServerInstanceStatus> VALUE_MAP;
    private final String value;

    private GameServerInstanceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GameServerInstanceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GameServerInstanceStatus> knownValues() {
        EnumSet<GameServerInstanceStatus> knownValues = EnumSet.allOf(GameServerInstanceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GameServerInstanceStatus.class, GameServerInstanceStatus::toString);
    }
}

