/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.MatchmakingTicket;
import software.amazon.awssdk.services.gamelift.model.MatchmakingTicketListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMatchmakingResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeMatchmakingResponse> {
    private static final SdkField<List<MatchmakingTicket>> TICKET_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TicketList").getter(DescribeMatchmakingResponse.getter(DescribeMatchmakingResponse::ticketList)).setter(DescribeMatchmakingResponse.setter(Builder::ticketList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TicketList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MatchmakingTicket::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TICKET_LIST_FIELD));
    private final List<MatchmakingTicket> ticketList;

    private DescribeMatchmakingResponse(BuilderImpl builder) {
        super(builder);
        this.ticketList = builder.ticketList;
    }

    public final boolean hasTicketList() {
        return this.ticketList != null && !(this.ticketList instanceof SdkAutoConstructList);
    }

    public final List<MatchmakingTicket> ticketList() {
        return this.ticketList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTicketList() ? this.ticketList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMatchmakingResponse)) {
            return false;
        }
        DescribeMatchmakingResponse other = (DescribeMatchmakingResponse)((Object)obj);
        return this.hasTicketList() == other.hasTicketList() && Objects.equals(this.ticketList(), other.ticketList());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMatchmakingResponse").add("TicketList", this.hasTicketList() ? this.ticketList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TicketList": {
                return Optional.ofNullable(clazz.cast(this.ticketList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMatchmakingResponse, T> g) {
        return obj -> g.apply((DescribeMatchmakingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<MatchmakingTicket> ticketList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMatchmakingResponse model) {
            super(model);
            this.ticketList(model.ticketList);
        }

        public final List<MatchmakingTicket.Builder> getTicketList() {
            List<MatchmakingTicket.Builder> result = MatchmakingTicketListCopier.copyToBuilder(this.ticketList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTicketList(Collection<MatchmakingTicket.BuilderImpl> ticketList) {
            this.ticketList = MatchmakingTicketListCopier.copyFromBuilder(ticketList);
        }

        @Override
        public final Builder ticketList(Collection<MatchmakingTicket> ticketList) {
            this.ticketList = MatchmakingTicketListCopier.copy(ticketList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ticketList(MatchmakingTicket ... ticketList) {
            this.ticketList(Arrays.asList(ticketList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ticketList(Consumer<MatchmakingTicket.Builder> ... ticketList) {
            this.ticketList(Stream.of(ticketList).map(c -> (MatchmakingTicket)((MatchmakingTicket.Builder)MatchmakingTicket.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeMatchmakingResponse build() {
            return new DescribeMatchmakingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMatchmakingResponse> {
        public Builder ticketList(Collection<MatchmakingTicket> var1);

        public Builder ticketList(MatchmakingTicket ... var1);

        public Builder ticketList(Consumer<MatchmakingTicket.Builder> ... var1);
    }
}

