/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.FleetCapacity;

public class DescribeFleetCapacityIterable
implements SdkIterable<DescribeFleetCapacityResponse> {
    private final GameLiftClient client;
    private final DescribeFleetCapacityRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFleetCapacityIterable(GameLiftClient client, DescribeFleetCapacityRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeFleetCapacityResponseFetcher();
    }

    public Iterator<DescribeFleetCapacityResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FleetCapacity> fleetCapacity() {
        Function<DescribeFleetCapacityResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleetCapacity() != null) {
                return response.fleetCapacity().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeFleetCapacityResponseFetcher
    implements SyncPageFetcher<DescribeFleetCapacityResponse> {
        private DescribeFleetCapacityResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFleetCapacityResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFleetCapacityResponse nextPage(DescribeFleetCapacityResponse previousPage) {
            if (previousPage == null) {
                return DescribeFleetCapacityIterable.this.client.describeFleetCapacity(DescribeFleetCapacityIterable.this.firstRequest);
            }
            return DescribeFleetCapacityIterable.this.client.describeFleetCapacity((DescribeFleetCapacityRequest)((Object)DescribeFleetCapacityIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

