/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetricName {
    ACTIVATING_GAME_SESSIONS("ActivatingGameSessions"),
    ACTIVE_GAME_SESSIONS("ActiveGameSessions"),
    ACTIVE_INSTANCES("ActiveInstances"),
    AVAILABLE_GAME_SESSIONS("AvailableGameSessions"),
    AVAILABLE_PLAYER_SESSIONS("AvailablePlayerSessions"),
    CURRENT_PLAYER_SESSIONS("CurrentPlayerSessions"),
    IDLE_INSTANCES("IdleInstances"),
    PERCENT_AVAILABLE_GAME_SESSIONS("PercentAvailableGameSessions"),
    PERCENT_IDLE_INSTANCES("PercentIdleInstances"),
    QUEUE_DEPTH("QueueDepth"),
    WAIT_TIME("WaitTime"),
    CONCURRENT_ACTIVATABLE_GAME_SESSIONS("ConcurrentActivatableGameSessions"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricName> VALUE_MAP;
    private final String value;

    private MetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricName> knownValues() {
        EnumSet<MetricName> knownValues = EnumSet.allOf(MetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetricName.class, MetricName::toString);
    }
}

