/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.GameSession;
import software.amazon.awssdk.services.gamelift.model.GameSessionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGameSessionsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, DescribeGameSessionsResponse> {
    private static final SdkField<List<GameSession>> GAME_SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GameSessions").getter(DescribeGameSessionsResponse.getter(DescribeGameSessionsResponse::gameSessions)).setter(DescribeGameSessionsResponse.setter(Builder::gameSessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeGameSessionsResponse.getter(DescribeGameSessionsResponse::nextToken)).setter(DescribeGameSessionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<GameSession> gameSessions;
    private final String nextToken;

    private DescribeGameSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.gameSessions = builder.gameSessions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGameSessions() {
        return this.gameSessions != null && !(this.gameSessions instanceof SdkAutoConstructList);
    }

    public final List<GameSession> gameSessions() {
        return this.gameSessions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGameSessions() ? this.gameSessions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameSessionsResponse)) {
            return false;
        }
        DescribeGameSessionsResponse other = (DescribeGameSessionsResponse)((Object)obj);
        return this.hasGameSessions() == other.hasGameSessions() && Objects.equals(this.gameSessions(), other.gameSessions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGameSessionsResponse").add("GameSessions", this.hasGameSessions() ? this.gameSessions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessions": {
                return Optional.ofNullable(clazz.cast(this.gameSessions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGameSessionsResponse, T> g) {
        return obj -> g.apply((DescribeGameSessionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<GameSession> gameSessions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameSessionsResponse model) {
            super(model);
            this.gameSessions(model.gameSessions);
            this.nextToken(model.nextToken);
        }

        public final List<GameSession.Builder> getGameSessions() {
            List<GameSession.Builder> result = GameSessionListCopier.copyToBuilder(this.gameSessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGameSessions(Collection<GameSession.BuilderImpl> gameSessions) {
            this.gameSessions = GameSessionListCopier.copyFromBuilder(gameSessions);
        }

        @Override
        public final Builder gameSessions(Collection<GameSession> gameSessions) {
            this.gameSessions = GameSessionListCopier.copy(gameSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessions(GameSession ... gameSessions) {
            this.gameSessions(Arrays.asList(gameSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessions(Consumer<GameSession.Builder> ... gameSessions) {
            this.gameSessions(Stream.of(gameSessions).map(c -> (GameSession)((GameSession.Builder)GameSession.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeGameSessionsResponse build() {
            return new DescribeGameSessionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGameSessionsResponse> {
        public Builder gameSessions(Collection<GameSession> var1);

        public Builder gameSessions(GameSession ... var1);

        public Builder gameSessions(Consumer<GameSession.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

