/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateScriptRequest extends GameLiftRequest implements
        ToCopyableBuilder<UpdateScriptRequest.Builder, UpdateScriptRequest> {
    private static final SdkField<String> SCRIPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScriptId").getter(getter(UpdateScriptRequest::scriptId)).setter(setter(Builder::scriptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateScriptRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(UpdateScriptRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<S3Location> STORAGE_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("StorageLocation").getter(getter(UpdateScriptRequest::storageLocation))
            .setter(setter(Builder::storageLocation)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLocation").build()).build();

    private static final SdkField<SdkBytes> ZIP_FILE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("ZipFile").getter(getter(UpdateScriptRequest::zipFile)).setter(setter(Builder::zipFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipFile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_ID_FIELD, NAME_FIELD,
            VERSION_FIELD, STORAGE_LOCATION_FIELD, ZIP_FILE_FIELD));

    private final String scriptId;

    private final String name;

    private final String version;

    private final S3Location storageLocation;

    private final SdkBytes zipFile;

    private UpdateScriptRequest(BuilderImpl builder) {
        super(builder);
        this.scriptId = builder.scriptId;
        this.name = builder.name;
        this.version = builder.version;
        this.storageLocation = builder.storageLocation;
        this.zipFile = builder.zipFile;
    }

    /**
     * <p>
     * A unique identifier for the Realtime script to update. You can use either the script ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for the Realtime script to update. You can use either the script ID or ARN value.
     */
    public final String scriptId() {
        return scriptId;
    }

    /**
     * <p>
     * A descriptive label that is associated with a script. Script names don't need to be unique.
     * </p>
     * 
     * @return A descriptive label that is associated with a script. Script names don't need to be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Version information associated with a build or script. Version strings don't need to be unique.
     * </p>
     * 
     * @return Version information associated with a build or script. Version strings don't need to be unique.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The storage
     * location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that allows Amazon
     * GameLift to access the Amazon S3 storage location. The S3 bucket must be in the same Region where you want to
     * create a new script. By default, Amazon GameLift uploads the latest version of the zip file; if you have S3
     * object versioning turned on, you can use the <code>ObjectVersion</code> parameter to specify an earlier version.
     * </p>
     * 
     * @return The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The
     *         storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN
     *         that allows Amazon GameLift to access the Amazon S3 storage location. The S3 bucket must be in the same
     *         Region where you want to create a new script. By default, Amazon GameLift uploads the latest version of
     *         the zip file; if you have S3 object versioning turned on, you can use the <code>ObjectVersion</code>
     *         parameter to specify an earlier version.
     */
    public final S3Location storageLocation() {
        return storageLocation;
    }

    /**
     * <p>
     * A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one or
     * multiple files. Maximum size of a zip file is 5 MB.
     * </p>
     * <p>
     * When using the Amazon Web Services CLI tool to create a script, this parameter is set to the zip file name. It
     * must be prepended with the string "fileb://" to indicate that the file data is a binary object. For example:
     * <code>--zip-file fileb://myRealtimeScript.zip</code>.
     * </p>
     * 
     * @return A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one
     *         or multiple files. Maximum size of a zip file is 5 MB.</p>
     *         <p>
     *         When using the Amazon Web Services CLI tool to create a script, this parameter is set to the zip file
     *         name. It must be prepended with the string "fileb://" to indicate that the file data is a binary object.
     *         For example: <code>--zip-file fileb://myRealtimeScript.zip</code>.
     */
    public final SdkBytes zipFile() {
        return zipFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scriptId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(storageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(zipFile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScriptRequest)) {
            return false;
        }
        UpdateScriptRequest other = (UpdateScriptRequest) obj;
        return Objects.equals(scriptId(), other.scriptId()) && Objects.equals(name(), other.name())
                && Objects.equals(version(), other.version()) && Objects.equals(storageLocation(), other.storageLocation())
                && Objects.equals(zipFile(), other.zipFile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateScriptRequest").add("ScriptId", scriptId()).add("Name", name()).add("Version", version())
                .add("StorageLocation", storageLocation()).add("ZipFile", zipFile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScriptId":
            return Optional.ofNullable(clazz.cast(scriptId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "StorageLocation":
            return Optional.ofNullable(clazz.cast(storageLocation()));
        case "ZipFile":
            return Optional.ofNullable(clazz.cast(zipFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateScriptRequest, T> g) {
        return obj -> g.apply((UpdateScriptRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateScriptRequest> {
        /**
         * <p>
         * A unique identifier for the Realtime script to update. You can use either the script ID or ARN value.
         * </p>
         * 
         * @param scriptId
         *        A unique identifier for the Realtime script to update. You can use either the script ID or ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptId(String scriptId);

        /**
         * <p>
         * A descriptive label that is associated with a script. Script names don't need to be unique.
         * </p>
         * 
         * @param name
         *        A descriptive label that is associated with a script. Script names don't need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Version information associated with a build or script. Version strings don't need to be unique.
         * </p>
         * 
         * @param version
         *        Version information associated with a build or script. Version strings don't need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The
         * storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that
         * allows Amazon GameLift to access the Amazon S3 storage location. The S3 bucket must be in the same Region
         * where you want to create a new script. By default, Amazon GameLift uploads the latest version of the zip
         * file; if you have S3 object versioning turned on, you can use the <code>ObjectVersion</code> parameter to
         * specify an earlier version.
         * </p>
         * 
         * @param storageLocation
         *        The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored.
         *        The storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role
         *        ARN that allows Amazon GameLift to access the Amazon S3 storage location. The S3 bucket must be in the
         *        same Region where you want to create a new script. By default, Amazon GameLift uploads the latest
         *        version of the zip file; if you have S3 object versioning turned on, you can use the
         *        <code>ObjectVersion</code> parameter to specify an earlier version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLocation(S3Location storageLocation);

        /**
         * <p>
         * The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The
         * storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that
         * allows Amazon GameLift to access the Amazon S3 storage location. The S3 bucket must be in the same Region
         * where you want to create a new script. By default, Amazon GameLift uploads the latest version of the zip
         * file; if you have S3 object versioning turned on, you can use the <code>ObjectVersion</code> parameter to
         * specify an earlier version.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #storageLocation(S3Location)}.
         * 
         * @param storageLocation
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLocation(S3Location)
         */
        default Builder storageLocation(Consumer<S3Location.Builder> storageLocation) {
            return storageLocation(S3Location.builder().applyMutation(storageLocation).build());
        }

        /**
         * <p>
         * A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have one or
         * multiple files. Maximum size of a zip file is 5 MB.
         * </p>
         * <p>
         * When using the Amazon Web Services CLI tool to create a script, this parameter is set to the zip file name.
         * It must be prepended with the string "fileb://" to indicate that the file data is a binary object. For
         * example: <code>--zip-file fileb://myRealtimeScript.zip</code>.
         * </p>
         * 
         * @param zipFile
         *        A data object containing your Realtime scripts and dependencies as a zip file. The zip file can have
         *        one or multiple files. Maximum size of a zip file is 5 MB.</p>
         *        <p>
         *        When using the Amazon Web Services CLI tool to create a script, this parameter is set to the zip file
         *        name. It must be prepended with the string "fileb://" to indicate that the file data is a binary
         *        object. For example: <code>--zip-file fileb://myRealtimeScript.zip</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zipFile(SdkBytes zipFile);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String scriptId;

        private String name;

        private String version;

        private S3Location storageLocation;

        private SdkBytes zipFile;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScriptRequest model) {
            super(model);
            scriptId(model.scriptId);
            name(model.name);
            version(model.version);
            storageLocation(model.storageLocation);
            zipFile(model.zipFile);
        }

        public final String getScriptId() {
            return scriptId;
        }

        public final void setScriptId(String scriptId) {
            this.scriptId = scriptId;
        }

        @Override
        public final Builder scriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final S3Location.Builder getStorageLocation() {
            return storageLocation != null ? storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(S3Location.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public final Builder storageLocation(S3Location storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final ByteBuffer getZipFile() {
            return zipFile == null ? null : zipFile.asByteBuffer();
        }

        public final void setZipFile(ByteBuffer zipFile) {
            zipFile(zipFile == null ? null : SdkBytes.fromByteBuffer(zipFile));
        }

        @Override
        public final Builder zipFile(SdkBytes zipFile) {
            this.zipFile = zipFile;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScriptRequest build() {
            return new UpdateScriptRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
