/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEc2InstanceLimitsRequest extends GameLiftRequest implements
        ToCopyableBuilder<DescribeEc2InstanceLimitsRequest.Builder, DescribeEc2InstanceLimitsRequest> {
    private static final SdkField<String> EC2_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2InstanceType").getter(getter(DescribeEc2InstanceLimitsRequest::ec2InstanceTypeAsString))
            .setter(setter(Builder::ec2InstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceType").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(DescribeEc2InstanceLimitsRequest::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_INSTANCE_TYPE_FIELD,
            LOCATION_FIELD));

    private final String ec2InstanceType;

    private final String location;

    private DescribeEc2InstanceLimitsRequest(BuilderImpl builder) {
        super(builder);
        this.ec2InstanceType = builder.ec2InstanceType;
        this.location = builder.location;
    }

    /**
     * <p>
     * Name of an Amazon EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
     * computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Do
     * not specify a value for this parameter to retrieve limits for all instance types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2InstanceType}
     * will return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ec2InstanceTypeAsString}.
     * </p>
     * 
     * @return Name of an Amazon EC2 instance type that is supported in Amazon GameLift. A fleet instance type
     *         determines the computing resources of each instance in the fleet, including CPU, memory, storage, and
     *         networking capacity. Do not specify a value for this parameter to retrieve limits for all instance types.
     * @see EC2InstanceType
     */
    public final EC2InstanceType ec2InstanceType() {
        return EC2InstanceType.fromValue(ec2InstanceType);
    }

    /**
     * <p>
     * Name of an Amazon EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines the
     * computing resources of each instance in the fleet, including CPU, memory, storage, and networking capacity. Do
     * not specify a value for this parameter to retrieve limits for all instance types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2InstanceType}
     * will return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ec2InstanceTypeAsString}.
     * </p>
     * 
     * @return Name of an Amazon EC2 instance type that is supported in Amazon GameLift. A fleet instance type
     *         determines the computing resources of each instance in the fleet, including CPU, memory, storage, and
     *         networking capacity. Do not specify a value for this parameter to retrieve limits for all instance types.
     * @see EC2InstanceType
     */
    public final String ec2InstanceTypeAsString() {
        return ec2InstanceType;
    }

    /**
     * <p>
     * The name of a remote location to request instance limits for, in the form of an Amazon Web Services Region code
     * such as <code>us-west-2</code>.
     * </p>
     * 
     * @return The name of a remote location to request instance limits for, in the form of an Amazon Web Services
     *         Region code such as <code>us-west-2</code>.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEc2InstanceLimitsRequest)) {
            return false;
        }
        DescribeEc2InstanceLimitsRequest other = (DescribeEc2InstanceLimitsRequest) obj;
        return Objects.equals(ec2InstanceTypeAsString(), other.ec2InstanceTypeAsString())
                && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEc2InstanceLimitsRequest").add("EC2InstanceType", ec2InstanceTypeAsString())
                .add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EC2InstanceType":
            return Optional.ofNullable(clazz.cast(ec2InstanceTypeAsString()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEc2InstanceLimitsRequest, T> g) {
        return obj -> g.apply((DescribeEc2InstanceLimitsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEc2InstanceLimitsRequest> {
        /**
         * <p>
         * Name of an Amazon EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines
         * the computing resources of each instance in the fleet, including CPU, memory, storage, and networking
         * capacity. Do not specify a value for this parameter to retrieve limits for all instance types.
         * </p>
         * 
         * @param ec2InstanceType
         *        Name of an Amazon EC2 instance type that is supported in Amazon GameLift. A fleet instance type
         *        determines the computing resources of each instance in the fleet, including CPU, memory, storage, and
         *        networking capacity. Do not specify a value for this parameter to retrieve limits for all instance
         *        types.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder ec2InstanceType(String ec2InstanceType);

        /**
         * <p>
         * Name of an Amazon EC2 instance type that is supported in Amazon GameLift. A fleet instance type determines
         * the computing resources of each instance in the fleet, including CPU, memory, storage, and networking
         * capacity. Do not specify a value for this parameter to retrieve limits for all instance types.
         * </p>
         * 
         * @param ec2InstanceType
         *        Name of an Amazon EC2 instance type that is supported in Amazon GameLift. A fleet instance type
         *        determines the computing resources of each instance in the fleet, including CPU, memory, storage, and
         *        networking capacity. Do not specify a value for this parameter to retrieve limits for all instance
         *        types.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder ec2InstanceType(EC2InstanceType ec2InstanceType);

        /**
         * <p>
         * The name of a remote location to request instance limits for, in the form of an Amazon Web Services Region
         * code such as <code>us-west-2</code>.
         * </p>
         * 
         * @param location
         *        The name of a remote location to request instance limits for, in the form of an Amazon Web Services
         *        Region code such as <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String ec2InstanceType;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEc2InstanceLimitsRequest model) {
            super(model);
            ec2InstanceType(model.ec2InstanceType);
            location(model.location);
        }

        public final String getEc2InstanceType() {
            return ec2InstanceType;
        }

        public final void setEc2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        public final Builder ec2InstanceType(EC2InstanceType ec2InstanceType) {
            this.ec2InstanceType(ec2InstanceType == null ? null : ec2InstanceType.toString());
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEc2InstanceLimitsRequest build() {
            return new DescribeEc2InstanceLimitsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
