/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameSessionConnectionInfo;
import software.amazon.awssdk.services.gamelift.model.MatchmakingConfigurationStatus;
import software.amazon.awssdk.services.gamelift.model.Player;
import software.amazon.awssdk.services.gamelift.model.PlayerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatchmakingTicket
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MatchmakingTicket> {
    private static final SdkField<String> TICKET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TicketId").getter(MatchmakingTicket.getter(MatchmakingTicket::ticketId)).setter(MatchmakingTicket.setter(Builder::ticketId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TicketId").build()}).build();
    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationName").getter(MatchmakingTicket.getter(MatchmakingTicket::configurationName)).setter(MatchmakingTicket.setter(Builder::configurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()}).build();
    private static final SdkField<String> CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationArn").getter(MatchmakingTicket.getter(MatchmakingTicket::configurationArn)).setter(MatchmakingTicket.setter(Builder::configurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MatchmakingTicket.getter(MatchmakingTicket::statusAsString)).setter(MatchmakingTicket.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(MatchmakingTicket.getter(MatchmakingTicket::statusReason)).setter(MatchmakingTicket.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(MatchmakingTicket.getter(MatchmakingTicket::statusMessage)).setter(MatchmakingTicket.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(MatchmakingTicket.getter(MatchmakingTicket::startTime)).setter(MatchmakingTicket.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(MatchmakingTicket.getter(MatchmakingTicket::endTime)).setter(MatchmakingTicket.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<List<Player>> PLAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Players").getter(MatchmakingTicket.getter(MatchmakingTicket::players)).setter(MatchmakingTicket.setter(Builder::players)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Players").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Player::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GameSessionConnectionInfo> GAME_SESSION_CONNECTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GameSessionConnectionInfo").getter(MatchmakingTicket.getter(MatchmakingTicket::gameSessionConnectionInfo)).setter(MatchmakingTicket.setter(Builder::gameSessionConnectionInfo)).constructor(GameSessionConnectionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionConnectionInfo").build()}).build();
    private static final SdkField<Integer> ESTIMATED_WAIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EstimatedWaitTime").getter(MatchmakingTicket.getter(MatchmakingTicket::estimatedWaitTime)).setter(MatchmakingTicket.setter(Builder::estimatedWaitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedWaitTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TICKET_ID_FIELD, CONFIGURATION_NAME_FIELD, CONFIGURATION_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, STATUS_MESSAGE_FIELD, START_TIME_FIELD, END_TIME_FIELD, PLAYERS_FIELD, GAME_SESSION_CONNECTION_INFO_FIELD, ESTIMATED_WAIT_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ticketId;
    private final String configurationName;
    private final String configurationArn;
    private final String status;
    private final String statusReason;
    private final String statusMessage;
    private final Instant startTime;
    private final Instant endTime;
    private final List<Player> players;
    private final GameSessionConnectionInfo gameSessionConnectionInfo;
    private final Integer estimatedWaitTime;

    private MatchmakingTicket(BuilderImpl builder) {
        this.ticketId = builder.ticketId;
        this.configurationName = builder.configurationName;
        this.configurationArn = builder.configurationArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.statusMessage = builder.statusMessage;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.players = builder.players;
        this.gameSessionConnectionInfo = builder.gameSessionConnectionInfo;
        this.estimatedWaitTime = builder.estimatedWaitTime;
    }

    public final String ticketId() {
        return this.ticketId;
    }

    public final String configurationName() {
        return this.configurationName;
    }

    public final String configurationArn() {
        return this.configurationArn;
    }

    public final MatchmakingConfigurationStatus status() {
        return MatchmakingConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasPlayers() {
        return this.players != null && !(this.players instanceof SdkAutoConstructList);
    }

    public final List<Player> players() {
        return this.players;
    }

    public final GameSessionConnectionInfo gameSessionConnectionInfo() {
        return this.gameSessionConnectionInfo;
    }

    public final Integer estimatedWaitTime() {
        return this.estimatedWaitTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ticketId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlayers() ? this.players() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionConnectionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedWaitTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchmakingTicket)) {
            return false;
        }
        MatchmakingTicket other = (MatchmakingTicket)obj;
        return Objects.equals(this.ticketId(), other.ticketId()) && Objects.equals(this.configurationName(), other.configurationName()) && Objects.equals(this.configurationArn(), other.configurationArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasPlayers() == other.hasPlayers() && Objects.equals(this.players(), other.players()) && Objects.equals(this.gameSessionConnectionInfo(), other.gameSessionConnectionInfo()) && Objects.equals(this.estimatedWaitTime(), other.estimatedWaitTime());
    }

    public final String toString() {
        return ToString.builder((String)"MatchmakingTicket").add("TicketId", (Object)this.ticketId()).add("ConfigurationName", (Object)this.configurationName()).add("ConfigurationArn", (Object)this.configurationArn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("StatusMessage", (Object)this.statusMessage()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Players", this.hasPlayers() ? this.players() : null).add("GameSessionConnectionInfo", (Object)this.gameSessionConnectionInfo()).add("EstimatedWaitTime", (Object)this.estimatedWaitTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TicketId": {
                return Optional.ofNullable(clazz.cast(this.ticketId()));
            }
            case "ConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.configurationName()));
            }
            case "ConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.configurationArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Players": {
                return Optional.ofNullable(clazz.cast(this.players()));
            }
            case "GameSessionConnectionInfo": {
                return Optional.ofNullable(clazz.cast(this.gameSessionConnectionInfo()));
            }
            case "EstimatedWaitTime": {
                return Optional.ofNullable(clazz.cast(this.estimatedWaitTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MatchmakingTicket, T> g) {
        return obj -> g.apply((MatchmakingTicket)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ticketId;
        private String configurationName;
        private String configurationArn;
        private String status;
        private String statusReason;
        private String statusMessage;
        private Instant startTime;
        private Instant endTime;
        private List<Player> players = DefaultSdkAutoConstructList.getInstance();
        private GameSessionConnectionInfo gameSessionConnectionInfo;
        private Integer estimatedWaitTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchmakingTicket model) {
            this.ticketId(model.ticketId);
            this.configurationName(model.configurationName);
            this.configurationArn(model.configurationArn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.statusMessage(model.statusMessage);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.players(model.players);
            this.gameSessionConnectionInfo(model.gameSessionConnectionInfo);
            this.estimatedWaitTime(model.estimatedWaitTime);
        }

        public final String getTicketId() {
            return this.ticketId;
        }

        public final void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        @Override
        @Transient
        public final Builder ticketId(String ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public final String getConfigurationName() {
            return this.configurationName;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        @Transient
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final String getConfigurationArn() {
            return this.configurationArn;
        }

        public final void setConfigurationArn(String configurationArn) {
            this.configurationArn = configurationArn;
        }

        @Override
        @Transient
        public final Builder configurationArn(String configurationArn) {
            this.configurationArn = configurationArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(MatchmakingConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        @Transient
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<Player.Builder> getPlayers() {
            List<Player.Builder> result = PlayerListCopier.copyToBuilder(this.players);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlayers(Collection<Player.BuilderImpl> players) {
            this.players = PlayerListCopier.copyFromBuilder(players);
        }

        @Override
        @Transient
        public final Builder players(Collection<Player> players) {
            this.players = PlayerListCopier.copy(players);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder players(Player ... players) {
            this.players(Arrays.asList(players));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder players(Consumer<Player.Builder> ... players) {
            this.players(Stream.of(players).map(c -> (Player)((Player.Builder)Player.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GameSessionConnectionInfo.Builder getGameSessionConnectionInfo() {
            return this.gameSessionConnectionInfo != null ? this.gameSessionConnectionInfo.toBuilder() : null;
        }

        public final void setGameSessionConnectionInfo(GameSessionConnectionInfo.BuilderImpl gameSessionConnectionInfo) {
            this.gameSessionConnectionInfo = gameSessionConnectionInfo != null ? gameSessionConnectionInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder gameSessionConnectionInfo(GameSessionConnectionInfo gameSessionConnectionInfo) {
            this.gameSessionConnectionInfo = gameSessionConnectionInfo;
            return this;
        }

        public final Integer getEstimatedWaitTime() {
            return this.estimatedWaitTime;
        }

        public final void setEstimatedWaitTime(Integer estimatedWaitTime) {
            this.estimatedWaitTime = estimatedWaitTime;
        }

        @Override
        @Transient
        public final Builder estimatedWaitTime(Integer estimatedWaitTime) {
            this.estimatedWaitTime = estimatedWaitTime;
            return this;
        }

        public MatchmakingTicket build() {
            return new MatchmakingTicket(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MatchmakingTicket> {
        public Builder ticketId(String var1);

        public Builder configurationName(String var1);

        public Builder configurationArn(String var1);

        public Builder status(String var1);

        public Builder status(MatchmakingConfigurationStatus var1);

        public Builder statusReason(String var1);

        public Builder statusMessage(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder players(Collection<Player> var1);

        public Builder players(Player ... var1);

        public Builder players(Consumer<Player.Builder> ... var1);

        public Builder gameSessionConnectionInfo(GameSessionConnectionInfo var1);

        default public Builder gameSessionConnectionInfo(Consumer<GameSessionConnectionInfo.Builder> gameSessionConnectionInfo) {
            return this.gameSessionConnectionInfo((GameSessionConnectionInfo)((GameSessionConnectionInfo.Builder)GameSessionConnectionInfo.builder().applyMutation(gameSessionConnectionInfo)).build());
        }

        public Builder estimatedWaitTime(Integer var1);
    }
}

