/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.services.gamelift.model.Script;
import software.amazon.awssdk.services.gamelift.model.ScriptListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScriptsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, ListScriptsResponse> {
    private static final SdkField<List<Script>> SCRIPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Scripts").getter(ListScriptsResponse.getter(ListScriptsResponse::scripts)).setter(ListScriptsResponse.setter(Builder::scripts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scripts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Script::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListScriptsResponse.getter(ListScriptsResponse::nextToken)).setter(ListScriptsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Script> scripts;
    private final String nextToken;

    private ListScriptsResponse(BuilderImpl builder) {
        super(builder);
        this.scripts = builder.scripts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScripts() {
        return this.scripts != null && !(this.scripts instanceof SdkAutoConstructList);
    }

    public final List<Script> scripts() {
        return this.scripts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScripts() ? this.scripts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScriptsResponse)) {
            return false;
        }
        ListScriptsResponse other = (ListScriptsResponse)((Object)obj);
        return this.hasScripts() == other.hasScripts() && Objects.equals(this.scripts(), other.scripts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListScriptsResponse").add("Scripts", this.hasScripts() ? this.scripts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scripts": {
                return Optional.ofNullable(clazz.cast(this.scripts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListScriptsResponse, T> g) {
        return obj -> g.apply((ListScriptsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<Script> scripts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScriptsResponse model) {
            super(model);
            this.scripts(model.scripts);
            this.nextToken(model.nextToken);
        }

        public final List<Script.Builder> getScripts() {
            List<Script.Builder> result = ScriptListCopier.copyToBuilder(this.scripts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScripts(Collection<Script.BuilderImpl> scripts) {
            this.scripts = ScriptListCopier.copyFromBuilder(scripts);
        }

        @Override
        @Transient
        public final Builder scripts(Collection<Script> scripts) {
            this.scripts = ScriptListCopier.copy(scripts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scripts(Script ... scripts) {
            this.scripts(Arrays.asList(scripts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder scripts(Consumer<Script.Builder> ... scripts) {
            this.scripts(Stream.of(scripts).map(c -> (Script)((Script.Builder)Script.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListScriptsResponse build() {
            return new ListScriptsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScriptsResponse> {
        public Builder scripts(Collection<Script> var1);

        public Builder scripts(Script ... var1);

        public Builder scripts(Consumer<Script.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

