/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse;
import software.amazon.awssdk.services.gamelift.model.MatchmakingRuleSet;

public class DescribeMatchmakingRuleSetsIterable
implements SdkIterable<DescribeMatchmakingRuleSetsResponse> {
    private final GameLiftClient client;
    private final DescribeMatchmakingRuleSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMatchmakingRuleSetsIterable(GameLiftClient client, DescribeMatchmakingRuleSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeMatchmakingRuleSetsResponseFetcher();
    }

    public Iterator<DescribeMatchmakingRuleSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MatchmakingRuleSet> ruleSets() {
        Function<DescribeMatchmakingRuleSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ruleSets() != null) {
                return response.ruleSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMatchmakingRuleSetsResponseFetcher
    implements SyncPageFetcher<DescribeMatchmakingRuleSetsResponse> {
        private DescribeMatchmakingRuleSetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMatchmakingRuleSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMatchmakingRuleSetsResponse nextPage(DescribeMatchmakingRuleSetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMatchmakingRuleSetsIterable.this.client.describeMatchmakingRuleSets(DescribeMatchmakingRuleSetsIterable.this.firstRequest);
            }
            return DescribeMatchmakingRuleSetsIterable.this.client.describeMatchmakingRuleSets((DescribeMatchmakingRuleSetsRequest)((Object)DescribeMatchmakingRuleSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

