/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse;
import software.amazon.awssdk.services.gamelift.model.FleetUtilization;

public class DescribeFleetUtilizationPublisher
implements SdkPublisher<DescribeFleetUtilizationResponse> {
    private final GameLiftAsyncClient client;
    private final DescribeFleetUtilizationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFleetUtilizationPublisher(GameLiftAsyncClient client, DescribeFleetUtilizationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFleetUtilizationPublisher(GameLiftAsyncClient client, DescribeFleetUtilizationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFleetUtilizationResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFleetUtilizationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FleetUtilization> fleetUtilization() {
        Function<DescribeFleetUtilizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleetUtilization() != null) {
                return response.fleetUtilization().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeFleetUtilizationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeFleetUtilizationResponseFetcher
    implements AsyncPageFetcher<DescribeFleetUtilizationResponse> {
        private DescribeFleetUtilizationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFleetUtilizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFleetUtilizationResponse> nextPage(DescribeFleetUtilizationResponse previousPage) {
            if (previousPage == null) {
                return DescribeFleetUtilizationPublisher.this.client.describeFleetUtilization(DescribeFleetUtilizationPublisher.this.firstRequest);
            }
            return DescribeFleetUtilizationPublisher.this.client.describeFleetUtilization((DescribeFleetUtilizationRequest)((Object)DescribeFleetUtilizationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

