/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fsx.FSxClient;
import software.amazon.awssdk.services.fsx.internal.UserAgentUtils;
import software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest;
import software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesResponse;
import software.amazon.awssdk.services.fsx.model.StorageVirtualMachine;

public class DescribeStorageVirtualMachinesIterable
implements SdkIterable<DescribeStorageVirtualMachinesResponse> {
    private final FSxClient client;
    private final DescribeStorageVirtualMachinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeStorageVirtualMachinesIterable(FSxClient client, DescribeStorageVirtualMachinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeStorageVirtualMachinesResponseFetcher();
    }

    public Iterator<DescribeStorageVirtualMachinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StorageVirtualMachine> storageVirtualMachines() {
        Function<DescribeStorageVirtualMachinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.storageVirtualMachines() != null) {
                return response.storageVirtualMachines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeStorageVirtualMachinesResponseFetcher
    implements SyncPageFetcher<DescribeStorageVirtualMachinesResponse> {
        private DescribeStorageVirtualMachinesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStorageVirtualMachinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeStorageVirtualMachinesResponse nextPage(DescribeStorageVirtualMachinesResponse previousPage) {
            if (previousPage == null) {
                return DescribeStorageVirtualMachinesIterable.this.client.describeStorageVirtualMachines(DescribeStorageVirtualMachinesIterable.this.firstRequest);
            }
            return DescribeStorageVirtualMachinesIterable.this.client.describeStorageVirtualMachines((DescribeStorageVirtualMachinesRequest)((Object)DescribeStorageVirtualMachinesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

