/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WindowsDeploymentType {
    MULTI_AZ_1("MULTI_AZ_1"),
    SINGLE_AZ_1("SINGLE_AZ_1"),
    SINGLE_AZ_2("SINGLE_AZ_2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WindowsDeploymentType> VALUE_MAP;
    private final String value;

    private WindowsDeploymentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WindowsDeploymentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WindowsDeploymentType> knownValues() {
        EnumSet<WindowsDeploymentType> knownValues = EnumSet.allOf(WindowsDeploymentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WindowsDeploymentType.class, WindowsDeploymentType::toString);
    }
}

