/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStorageVirtualMachineRequest extends FSxRequest implements
        ToCopyableBuilder<UpdateStorageVirtualMachineRequest.Builder, UpdateStorageVirtualMachineRequest> {
    private static final SdkField<UpdateSvmActiveDirectoryConfiguration> ACTIVE_DIRECTORY_CONFIGURATION_FIELD = SdkField
            .<UpdateSvmActiveDirectoryConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ActiveDirectoryConfiguration")
            .getter(getter(UpdateStorageVirtualMachineRequest::activeDirectoryConfiguration))
            .setter(setter(Builder::activeDirectoryConfiguration))
            .constructor(UpdateSvmActiveDirectoryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryConfiguration")
                    .build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(UpdateStorageVirtualMachineRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> STORAGE_VIRTUAL_MACHINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageVirtualMachineId").getter(getter(UpdateStorageVirtualMachineRequest::storageVirtualMachineId))
            .setter(setter(Builder::storageVirtualMachineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineId").build())
            .build();

    private static final SdkField<String> SVM_ADMIN_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SvmAdminPassword").getter(getter(UpdateStorageVirtualMachineRequest::svmAdminPassword))
            .setter(setter(Builder::svmAdminPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SvmAdminPassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACTIVE_DIRECTORY_CONFIGURATION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, STORAGE_VIRTUAL_MACHINE_ID_FIELD,
            SVM_ADMIN_PASSWORD_FIELD));

    private final UpdateSvmActiveDirectoryConfiguration activeDirectoryConfiguration;

    private final String clientRequestToken;

    private final String storageVirtualMachineId;

    private final String svmAdminPassword;

    private UpdateStorageVirtualMachineRequest(BuilderImpl builder) {
        super(builder);
        this.activeDirectoryConfiguration = builder.activeDirectoryConfiguration;
        this.clientRequestToken = builder.clientRequestToken;
        this.storageVirtualMachineId = builder.storageVirtualMachineId;
        this.svmAdminPassword = builder.svmAdminPassword;
    }

    /**
     * <p>
     * Specifies updates to an SVM's Microsoft Active Directory (AD) configuration.
     * </p>
     * 
     * @return Specifies updates to an SVM's Microsoft Active Directory (AD) configuration.
     */
    public final UpdateSvmActiveDirectoryConfiguration activeDirectoryConfiguration() {
        return activeDirectoryConfiguration;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The ID of the SVM that you want to update, in the format <code>svm-0123456789abcdef0</code>.
     * </p>
     * 
     * @return The ID of the SVM that you want to update, in the format <code>svm-0123456789abcdef0</code>.
     */
    public final String storageVirtualMachineId() {
        return storageVirtualMachineId;
    }

    /**
     * <p>
     * Specifies a new SvmAdminPassword.
     * </p>
     * 
     * @return Specifies a new SvmAdminPassword.
     */
    public final String svmAdminPassword() {
        return svmAdminPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(storageVirtualMachineId());
        hashCode = 31 * hashCode + Objects.hashCode(svmAdminPassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStorageVirtualMachineRequest)) {
            return false;
        }
        UpdateStorageVirtualMachineRequest other = (UpdateStorageVirtualMachineRequest) obj;
        return Objects.equals(activeDirectoryConfiguration(), other.activeDirectoryConfiguration())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(storageVirtualMachineId(), other.storageVirtualMachineId())
                && Objects.equals(svmAdminPassword(), other.svmAdminPassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStorageVirtualMachineRequest")
                .add("ActiveDirectoryConfiguration", activeDirectoryConfiguration())
                .add("ClientRequestToken", clientRequestToken()).add("StorageVirtualMachineId", storageVirtualMachineId())
                .add("SvmAdminPassword", svmAdminPassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveDirectoryConfiguration":
            return Optional.ofNullable(clazz.cast(activeDirectoryConfiguration()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "StorageVirtualMachineId":
            return Optional.ofNullable(clazz.cast(storageVirtualMachineId()));
        case "SvmAdminPassword":
            return Optional.ofNullable(clazz.cast(svmAdminPassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStorageVirtualMachineRequest, T> g) {
        return obj -> g.apply((UpdateStorageVirtualMachineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStorageVirtualMachineRequest> {
        /**
         * <p>
         * Specifies updates to an SVM's Microsoft Active Directory (AD) configuration.
         * </p>
         * 
         * @param activeDirectoryConfiguration
         *        Specifies updates to an SVM's Microsoft Active Directory (AD) configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectoryConfiguration(UpdateSvmActiveDirectoryConfiguration activeDirectoryConfiguration);

        /**
         * <p>
         * Specifies updates to an SVM's Microsoft Active Directory (AD) configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateSvmActiveDirectoryConfiguration.Builder} avoiding the need to create one manually via
         * {@link UpdateSvmActiveDirectoryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateSvmActiveDirectoryConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #activeDirectoryConfiguration(UpdateSvmActiveDirectoryConfiguration)}.
         * 
         * @param activeDirectoryConfiguration
         *        a consumer that will call methods on {@link UpdateSvmActiveDirectoryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeDirectoryConfiguration(UpdateSvmActiveDirectoryConfiguration)
         */
        default Builder activeDirectoryConfiguration(
                Consumer<UpdateSvmActiveDirectoryConfiguration.Builder> activeDirectoryConfiguration) {
            return activeDirectoryConfiguration(UpdateSvmActiveDirectoryConfiguration.builder()
                    .applyMutation(activeDirectoryConfiguration).build());
        }

        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The ID of the SVM that you want to update, in the format <code>svm-0123456789abcdef0</code>.
         * </p>
         * 
         * @param storageVirtualMachineId
         *        The ID of the SVM that you want to update, in the format <code>svm-0123456789abcdef0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageVirtualMachineId(String storageVirtualMachineId);

        /**
         * <p>
         * Specifies a new SvmAdminPassword.
         * </p>
         * 
         * @param svmAdminPassword
         *        Specifies a new SvmAdminPassword.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder svmAdminPassword(String svmAdminPassword);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private UpdateSvmActiveDirectoryConfiguration activeDirectoryConfiguration;

        private String clientRequestToken;

        private String storageVirtualMachineId;

        private String svmAdminPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStorageVirtualMachineRequest model) {
            super(model);
            activeDirectoryConfiguration(model.activeDirectoryConfiguration);
            clientRequestToken(model.clientRequestToken);
            storageVirtualMachineId(model.storageVirtualMachineId);
            svmAdminPassword(model.svmAdminPassword);
        }

        public final UpdateSvmActiveDirectoryConfiguration.Builder getActiveDirectoryConfiguration() {
            return activeDirectoryConfiguration != null ? activeDirectoryConfiguration.toBuilder() : null;
        }

        public final void setActiveDirectoryConfiguration(
                UpdateSvmActiveDirectoryConfiguration.BuilderImpl activeDirectoryConfiguration) {
            this.activeDirectoryConfiguration = activeDirectoryConfiguration != null ? activeDirectoryConfiguration.build()
                    : null;
        }

        @Override
        public final Builder activeDirectoryConfiguration(UpdateSvmActiveDirectoryConfiguration activeDirectoryConfiguration) {
            this.activeDirectoryConfiguration = activeDirectoryConfiguration;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getStorageVirtualMachineId() {
            return storageVirtualMachineId;
        }

        public final void setStorageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
        }

        @Override
        public final Builder storageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
            return this;
        }

        public final String getSvmAdminPassword() {
            return svmAdminPassword;
        }

        public final void setSvmAdminPassword(String svmAdminPassword) {
            this.svmAdminPassword = svmAdminPassword;
        }

        @Override
        public final Builder svmAdminPassword(String svmAdminPassword) {
            this.svmAdminPassword = svmAdminPassword;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStorageVirtualMachineRequest build() {
            return new UpdateStorageVirtualMachineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
