/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotsRequest extends FSxRequest implements
        ToCopyableBuilder<DescribeSnapshotsRequest.Builder, DescribeSnapshotsRequest> {
    private static final SdkField<List<String>> SNAPSHOT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SnapshotIds")
            .getter(getter(DescribeSnapshotsRequest::snapshotIds))
            .setter(setter(Builder::snapshotIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SnapshotFilter>> FILTERS_FIELD = SdkField
            .<List<SnapshotFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeSnapshotsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SnapshotFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeSnapshotsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeSnapshotsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_IDS_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> snapshotIds;

    private final List<SnapshotFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotIds = builder.snapshotIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnapshotIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnapshotIds() {
        return snapshotIds != null && !(snapshotIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the snapshots that you want to retrieve. This parameter value overrides any filters. If any IDs aren't
     * found, a <code>SnapshotNotFound</code> error occurs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshotIds} method.
     * </p>
     * 
     * @return The IDs of the snapshots that you want to retrieve. This parameter value overrides any filters. If any
     *         IDs aren't found, a <code>SnapshotNotFound</code> error occurs.
     */
    public final List<String> snapshotIds() {
        return snapshotIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters structure. The supported names are <code>file-system-id</code> or <code>volume-id</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters structure. The supported names are <code>file-system-id</code> or <code>volume-id</code>.
     */
    public final List<SnapshotFilter> filters() {
        return filters;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshotIds() ? snapshotIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsRequest)) {
            return false;
        }
        DescribeSnapshotsRequest other = (DescribeSnapshotsRequest) obj;
        return hasSnapshotIds() == other.hasSnapshotIds() && Objects.equals(snapshotIds(), other.snapshotIds())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSnapshotsRequest").add("SnapshotIds", hasSnapshotIds() ? snapshotIds() : null)
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotIds":
            return Optional.ofNullable(clazz.cast(snapshotIds()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeSnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSnapshotsRequest> {
        /**
         * <p>
         * The IDs of the snapshots that you want to retrieve. This parameter value overrides any filters. If any IDs
         * aren't found, a <code>SnapshotNotFound</code> error occurs.
         * </p>
         * 
         * @param snapshotIds
         *        The IDs of the snapshots that you want to retrieve. This parameter value overrides any filters. If any
         *        IDs aren't found, a <code>SnapshotNotFound</code> error occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIds(Collection<String> snapshotIds);

        /**
         * <p>
         * The IDs of the snapshots that you want to retrieve. This parameter value overrides any filters. If any IDs
         * aren't found, a <code>SnapshotNotFound</code> error occurs.
         * </p>
         * 
         * @param snapshotIds
         *        The IDs of the snapshots that you want to retrieve. This parameter value overrides any filters. If any
         *        IDs aren't found, a <code>SnapshotNotFound</code> error occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIds(String... snapshotIds);

        /**
         * <p>
         * The filters structure. The supported names are <code>file-system-id</code> or <code>volume-id</code>.
         * </p>
         * 
         * @param filters
         *        The filters structure. The supported names are <code>file-system-id</code> or <code>volume-id</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<SnapshotFilter> filters);

        /**
         * <p>
         * The filters structure. The supported names are <code>file-system-id</code> or <code>volume-id</code>.
         * </p>
         * 
         * @param filters
         *        The filters structure. The supported names are <code>file-system-id</code> or <code>volume-id</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SnapshotFilter... filters);

        /**
         * <p>
         * The filters structure. The supported names are <code>file-system-id</code> or <code>volume-id</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.SnapshotFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.fsx.model.SnapshotFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fsx.model.SnapshotFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<SnapshotFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fsx.model.SnapshotFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<SnapshotFilter>)
         */
        Builder filters(Consumer<SnapshotFilter.Builder>... filters);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private List<String> snapshotIds = DefaultSdkAutoConstructList.getInstance();

        private List<SnapshotFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsRequest model) {
            super(model);
            snapshotIds(model.snapshotIds);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getSnapshotIds() {
            if (snapshotIds instanceof SdkAutoConstructList) {
                return null;
            }
            return snapshotIds;
        }

        public final void setSnapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdsCopier.copy(snapshotIds);
        }

        @Override
        public final Builder snapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdsCopier.copy(snapshotIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotIds(String... snapshotIds) {
            snapshotIds(Arrays.asList(snapshotIds));
            return this;
        }

        public final List<SnapshotFilter.Builder> getFilters() {
            List<SnapshotFilter.Builder> result = SnapshotFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<SnapshotFilter.BuilderImpl> filters) {
            this.filters = SnapshotFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<SnapshotFilter> filters) {
            this.filters = SnapshotFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SnapshotFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SnapshotFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> SnapshotFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSnapshotsRequest build() {
            return new DescribeSnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
